package es.upv.dsic.issi.dplfw.dfmconf.constraints;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;

import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;


/**
 * checks if an alternative group has at least one member selected 
 * when the parent is also selected
 * 
 * The check is done from the parent point of view, since it responds to a ChildSelectionChangeEvent
 * 
 * @author agomez
 *
 */
public class AlternativeGroupConstraint extends AbstractModelConstraint {


	public IStatus validate(IValidationContext context) {
		
		EObject eObject = context.getTarget();
		EMFEventType eventType = context.getEventType();
	
		List<IStatus> statuses = new ArrayList<IStatus>();
		
		// In the case of batch mode.
		if (eventType == EMFEventType.NULL) {
			if (eObject instanceof DocumentFeatureSelection) {
				DocumentFeatureSelection documentFeatureSelection = (DocumentFeatureSelection) eObject;
				statuses.addAll(validateDocumentFeatureSelection(context, documentFeatureSelection));
			}
		// Live mode
		} else {
			DocumentFeatureSelection documentFeatureSelection = (DocumentFeatureSelection) context.getTarget();
			statuses.addAll(validateDocumentFeatureSelection(context, documentFeatureSelection));
		}
		if (statuses != null && !statuses.isEmpty()) {
			return ConstraintStatus.createMultiStatus(context, statuses);
		}
		return context.createSuccessStatus();
	}


	protected List<DocumentFeatureSelection> getAlternativeChilds(DocumentFeatureSelection documentFeatureSelection) {
		List<DocumentFeatureSelection> selections = new ArrayList<DocumentFeatureSelection>();
		// Collect alternatives
		for (DocumentFeatureSelection selection : documentFeatureSelection.getChildrenSelection()) {
			if (selection.getDocumentFeature().getType().equals(FeatureType.ALTERNATIVE)) {
				selections.add(selection);
			}
		}
		return selections;
	}
	

	protected List<IStatus> validateDocumentFeatureSelection(IValidationContext context, DocumentFeatureSelection documentFeatureSelection) {
		List<IStatus> statuses = new ArrayList<IStatus>();
		List<DocumentFeatureSelection> alternatives = getAlternativeChilds(documentFeatureSelection);

		if (documentFeatureSelection.getSelected() == Boolean.TRUE && !alternatives.isEmpty()) {
			boolean noneSelected = true;
			for (DocumentFeatureSelection selection : alternatives) {
				if (selection.getSelected() == Boolean.TRUE) {
					noneSelected = false;
					break;
				}
			}
			if (noneSelected) {
				statuses.add(buildErrorStatus(context, documentFeatureSelection));
			}
		}
		return statuses;
	}

	protected ConstraintStatus buildErrorStatus(IValidationContext context, DocumentFeatureSelection featureSelection) {
		
		return ConstraintStatus.createStatus(context, featureSelection,
				null,
				"No alternative has been selected in \"{0}\" group",
				featureSelection.getDocumentFeature().getVisibleName());
	}
}
