/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfmconf;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfmconf.exceptions.FeatureModelNotFoundException;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Document Feature Model Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration#getDocumentFeatureModel <em>Document Feature Model</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration#getTopFeaturesSelection <em>Top Features Selection</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration#getDocumentFeatureModelURI <em>Document Feature Model URI</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration#getSelectedContexts <em>Selected Contexts</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration#getGlobalVariableAttributes <em>Global Variable Attributes</em>}</li>
 * </ul>
 *
 * @see es.upv.dsic.issi.dplfw.dfmconf.DfmconfPackage#getDocumentFeatureModelConfiguration()
 * @model
 * @generated
 */
public interface DocumentFeatureModelConfiguration extends EObject {
	/**
	 * Returns the value of the '<em><b>Document Feature Model</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Document Feature Model</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Document Feature Model</em>' reference.
	 * @see es.upv.dsic.issi.dplfw.dfmconf.DfmconfPackage#getDocumentFeatureModelConfiguration_DocumentFeatureModel()
	 * @model required="true" suppressedSetVisibility="true"
	 * @generated
	 */
	DocumentFeatureModel getDocumentFeatureModel();

	/**
	 * Returns the value of the '<em><b>Top Features Selection</b></em>' containment reference list.
	 * The list contents are of type {@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection}.
	 * It is bidirectional and its opposite is '{@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection#getModelOwner <em>Model Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Top Features Selection</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Top Features Selection</em>' containment reference list.
	 * @see es.upv.dsic.issi.dplfw.dfmconf.DfmconfPackage#getDocumentFeatureModelConfiguration_TopFeaturesSelection()
	 * @see es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection#getModelOwner
	 * @model opposite="modelOwner" containment="true" required="true"
	 * @generated
	 */
	EList<DocumentFeatureSelection> getTopFeaturesSelection();

	/**
	 * Returns the value of the '<em><b>Document Feature Model URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Document Feature Model URI</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Document Feature Model URI</em>' attribute.
	 * @see #setDocumentFeatureModelURI(URI)
	 * @see es.upv.dsic.issi.dplfw.dfmconf.DfmconfPackage#getDocumentFeatureModelConfiguration_DocumentFeatureModelURI()
	 * @model dataType="es.upv.dsic.issi.dplfw.datatypes.URI" required="true"
	 * @generated
	 */
	URI getDocumentFeatureModelURI();

	/**
	 * Sets the value of the '{@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration#getDocumentFeatureModelURI <em>Document Feature Model URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Document Feature Model URI</em>' attribute.
	 * @see #getDocumentFeatureModelURI()
	 * @generated
	 */
	void setDocumentFeatureModelURI(URI value);

	/**
	 * Returns the value of the '<em><b>Selected Contexts</b></em>' reference list.
	 * The list contents are of type {@link es.upv.dsic.issi.dplfw.dfm.DocumentContext}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Selected Contexts</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Selected Contexts</em>' reference list.
	 * @see #isSetSelectedContexts()
	 * @see #unsetSelectedContexts()
	 * @see es.upv.dsic.issi.dplfw.dfmconf.DfmconfPackage#getDocumentFeatureModelConfiguration_SelectedContexts()
	 * @model unsettable="true"
	 * @generated
	 */
	EList<DocumentContext> getSelectedContexts();

	/**
	 * Unsets the value of the '{@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration#getSelectedContexts <em>Selected Contexts</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetSelectedContexts()
	 * @see #getSelectedContexts()
	 * @generated
	 */
	void unsetSelectedContexts();

	/**
	 * Returns whether the value of the '{@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration#getSelectedContexts <em>Selected Contexts</em>}' reference list is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Selected Contexts</em>' reference list is set.
	 * @see #unsetSelectedContexts()
	 * @see #getSelectedContexts()
	 * @generated
	 */
	boolean isSetSelectedContexts();

	/**
	 * Returns the value of the '<em><b>Global Variable Attributes</b></em>' containment reference list.
	 * The list contents are of type {@link es.upv.dsic.issi.dplfw.dfmconf.VariableAttributeConfiguration}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Global Variable Attributes</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Global Variable Attributes</em>' containment reference list.
	 * @see es.upv.dsic.issi.dplfw.dfmconf.DfmconfPackage#getDocumentFeatureModelConfiguration_GlobalVariableAttributes()
	 * @model containment="true"
	 * @generated
	 */
	EList<VariableAttributeConfiguration> getGlobalVariableAttributes();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model exceptions="es.upv.dsic.issi.dplfw.dfmconf.FeatureModelNotFoundException"
	 * @generated
	 */
	void initialize() throws FeatureModelNotFoundException;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model exceptions="es.upv.dsic.issi.dplfw.dfmconf.FeatureModelNotFoundException"
	 * @generated
	 */
	void reconcile() throws FeatureModelNotFoundException;

} // DocumentFeatureModelConfiguration
