/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfmconf.presentation.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ValidationEvent;

public class ProblemsReporter
implements IValidationListener {
    public void validationOccurred(ValidationEvent event) {
        for (IConstraintStatus status : event.getValidationResults()) {
            if (status.isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus childStatus = iStatusArray[n2];
                    this.clearMarkerForStatus((IConstraintStatus)childStatus);
                    this.createMarkerForStatus((IConstraintStatus)childStatus);
                    ++n2;
                }
                continue;
            }
            this.clearMarkerForStatus(status);
            this.createMarkerForStatus(status);
        }
    }

    private void createMarkerForStatus(IConstraintStatus status) {
        EObject eObject = status.getTarget();
        String eObjURI = EcoreUtil.getURI((EObject)eObject).toString();
        String eObjFragment = EcoreUtil.getURI((EObject)eObject).fragment();
        IFile file = ProblemsReporter.getIResourceFromEObject(eObject);
        try {
            if (!status.isOK()) {
                if (status.isMultiStatus()) {
                    IStatus[] iStatusArray = status.getChildren();
                    int n = iStatusArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatus childStatus = iStatusArray[n2];
                        this.createMarkerForStatus((IConstraintStatus)childStatus);
                        ++n2;
                    }
                } else {
                    IMarker marker = file.createMarker("org.eclipse.emf.validation.problem");
                    marker.setAttribute("location", (Object)eObjFragment);
                    marker.setAttribute("severity", this.statusSeverityToMarkerSeverity(status.getSeverity()));
                    marker.setAttribute("message", (Object)status.getMessage());
                    marker.setAttribute("uri", (Object)eObjURI);
                    marker.setAttribute("sourceId", (Object)status.getConstraint().getDescriptor().getId());
                    if (status instanceof ConstraintStatus) {
                        ConstraintStatus constraintStatus = (ConstraintStatus)status;
                        StringBuilder builder = new StringBuilder();
                        for (EObject locus : constraintStatus.getResultLocus()) {
                            builder.append(EcoreUtil.getURI((EObject)locus).toString());
                            builder.append(" ");
                        }
                        marker.setAttribute("relatedURIs", (Object)builder.toString());
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void clearMarkerForStatus(IConstraintStatus status) {
        int n;
        int n2;
        IMarker[] iMarkerArray;
        EObject eObject = status.getTarget();
        IFile resource = ProblemsReporter.getIResourceFromEObject(eObject);
        try {
            iMarkerArray = resource.findMarkers("org.eclipse.emf.validation.problem", true, 0);
            n2 = iMarkerArray.length;
            n = 0;
            while (n < n2) {
                IMarker marker = iMarkerArray[n];
                if (marker.getAttribute("uri").equals(EcoreUtil.getURI((EObject)eObject).toString()) && marker.getAttribute("sourceId").equals(status.getConstraint().getDescriptor().getId())) {
                    marker.delete();
                }
                ++n;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (status.isMultiStatus()) {
            iMarkerArray = status.getChildren();
            n2 = iMarkerArray.length;
            n = 0;
            while (n < n2) {
                IMarker childStatus = iMarkerArray[n];
                this.clearMarkerForStatus((IConstraintStatus)childStatus);
                ++n;
            }
        }
    }

    private static IFile getIResourceFromEObject(EObject eObject) {
        String resourcePath = eObject.eResource().getURI().toPlatformString(true);
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resourcePath));
    }

    private int statusSeverityToMarkerSeverity(int statusSeverity) {
        switch (statusSeverity) {
            case 4: {
                return 2;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }
}

