package es.upv.dsic.issi.dplfw.dfmconf.presentation.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.marker.MarkerUtil;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ValidationEvent;

public class ProblemsReporter implements IValidationListener {
	
	public void validationOccurred(ValidationEvent event) {

		// Let's iterate over the new statuses an recreate the new valid ones
        for (IConstraintStatus status : event.getValidationResults()) {
        	if (status.isMultiStatus()) {
        		for (IStatus childStatus : status.getChildren()) {
					clearMarkerForStatus((IConstraintStatus) childStatus);
        			createMarkerForStatus((IConstraintStatus) childStatus);
        		}
        	} else {
				clearMarkerForStatus(status);
        		createMarkerForStatus(status);
        	}        		
        }
    }

	private void createMarkerForStatus(IConstraintStatus status) {
		EObject eObject = status.getTarget();
		String eObjURI = EcoreUtil.getURI(eObject).toString();
		String eObjFragment = EcoreUtil.getURI(eObject).fragment();
		IFile file = getIResourceFromEObject(eObject);
		
		try {
			if (!status.isOK()) {
				if (status.isMultiStatus()) {
					for (IStatus childStatus : status.getChildren()) {
						createMarkerForStatus((IConstraintStatus) childStatus);
					}
				} else {
					IMarker marker = file.createMarker(MarkerUtil.VALIDATION_MARKER_TYPE);
					marker.setAttribute(IMarker.LOCATION, eObjFragment);
					marker.setAttribute(IMarker.SEVERITY, statusSeverityToMarkerSeverity(status.getSeverity()));
					marker.setAttribute(IMarker.MESSAGE, status.getMessage());
					marker.setAttribute(EValidator.URI_ATTRIBUTE, eObjURI);
					marker.setAttribute(IMarker.SOURCE_ID, status.getConstraint().getDescriptor().getId());
					
					if (status instanceof ConstraintStatus) {
						ConstraintStatus constraintStatus = (ConstraintStatus) status;
						StringBuilder builder = new StringBuilder();
						for (EObject locus : constraintStatus.getResultLocus()) {
							builder.append(EcoreUtil.getURI(locus).toString());
							builder.append(" ");
						}
						marker.setAttribute(EValidator.RELATED_URIS_ATTRIBUTE, builder.toString());
					}
				}
				
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}
	
	private void clearMarkerForStatus(IConstraintStatus status) {
		EObject eObject = status.getTarget();
		IResource resource = getIResourceFromEObject(eObject);
		try {
			for (IMarker marker : resource.findMarkers(MarkerUtil.VALIDATION_MARKER_TYPE, true, IResource.DEPTH_ZERO)) {
				if (marker.getAttribute(EValidator.URI_ATTRIBUTE).equals(EcoreUtil.getURI(eObject).toString()) &&
						marker.getAttribute(IMarker.SOURCE_ID).equals(status.getConstraint().getDescriptor().getId())) {
					marker.delete();
				}
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
		
		if (status.isMultiStatus()) {
			for (IStatus childStatus : status.getChildren()) {
				clearMarkerForStatus((IConstraintStatus) childStatus);
			}
		}
	}
	
	private static IFile getIResourceFromEObject(EObject eObject) {
		String resourcePath = eObject.eResource().getURI().toPlatformString(true);
		return ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(resourcePath));
	}
	
	private int statusSeverityToMarkerSeverity(int statusSeverity) {
		switch (statusSeverity) {
			case IStatus.ERROR:
				return IMarker.SEVERITY_ERROR;
			case IStatus.INFO:
				return IMarker.SEVERITY_INFO;
			case IStatus.WARNING:
				return IMarker.SEVERITY_WARNING;
			default:
				return 0;
		}
	}
}