package es.upv.dsic.issi.dplfw.dfmconf.presentation.properties;

import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.Reference;
import es.upv.dsic.issi.dplfw.infoelements.VariableIEContents;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.SelectInfoElementVariablesWizard;


final class SelectReferenceInfoElementURICellEditor extends ExtendedDialogCellEditor {
	
	private Reference obj;

	SelectReferenceInfoElementURICellEditor(Composite composite, ILabelProvider labelProvider) {
		super(composite, labelProvider);
	}

	public SelectReferenceInfoElementURICellEditor(Composite composite,
			ILabelProvider labelProvider, ContentDocumentFeature cdf) {
		super(composite, labelProvider);
	}

	public SelectReferenceInfoElementURICellEditor(Composite composite,
			ILabelProvider labelProvider, Object object) {
		super(composite, labelProvider);
		this.obj = (Reference) object;
	}

	@Override
	protected Object openDialogBox(Control cellEditorWindow) {
		SelectInfoElementVariablesWizard wizard = new SelectInfoElementVariablesWizard(obj);
		WizardDialog wizardDialog = new WizardDialog(getControl().getShell(), wizard) {
			{
				// Initialization to allow the wizard to be non-modal
				setShellStyle(SWT.SHELL_TRIM);
			}
		};
		wizardDialog.create();
		wizardDialog.setBlockOnOpen(true);
		if (wizardDialog.open() == WizardDialog.OK) {
			VariableIEContents varIECont = wizard.getVariableIEContents();
			return wizard.getInfoElementUri().appendSegment(varIECont.getIdName());
		}
		return null;
	}
}