package es.upv.dsic.issi.dplfw.dfmconf.presentation.properties;

import java.util.Collection;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

import es.upv.dsic.issi.dplfw.dfmconf.CriterionAttributeConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.DfmconfPackage;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;
import es.upv.dsic.issi.dplfw.dfmconf.Reference;
import es.upv.dsic.issi.dplfw.dfmconf.VariableAttributeConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.presentation.DfmconfEditor;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.SelectInfoElementWizard;

public class InfoElementCandidatePropertySection
	extends AbstractDfmconfPropertySection {

	private Text text;
	private SelectInfoElementWizard wizard;
	
	@Override
	public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);
		Composite composite = getWidgetFactory().createFlatFormComposite(parent);
		
	
		Composite buttonsComposite = getWidgetFactory().createFlatFormComposite(composite);
		RowLayout rowLayout = new RowLayout(SWT.VERTICAL);
		rowLayout.fill = true;
		rowLayout.marginTop = 0;
		rowLayout.marginBottom = 0;
		rowLayout.marginLeft = 0;
		rowLayout.marginRight = 0;
		buttonsComposite.setLayout(rowLayout);
		
		
		FormData data;

		text = getWidgetFactory().createText(composite, ""); //$NON-NLS-1$
		data = new FormData();
		data.left = new FormAttachment(0, getStandardLabelWidth(composite, new String[] {"InfoElement Candidate:"}));
		data.right = new FormAttachment(buttonsComposite, -ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(3, ITabbedPropertyConstants.VSPACE);
		text.setLayoutData(data);
		text.setEnabled(false);
		
		CLabel ieURICandidateLabel = getWidgetFactory().createCLabel(composite, "InfoElement Candidate:");
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(text, -ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(text, 3, SWT.CENTER);
		ieURICandidateLabel.setLayoutData(data);		
		
	
		
		data = new FormData();
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(text, -5, SWT.CENTER);
		buttonsComposite.setLayoutData(data);
				
		Button editButton = getWidgetFactory().createButton(buttonsComposite, "Edit...", SWT.PUSH);
		
		editButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				handleEdit();
			}
		});
		
	}


	protected void handleEdit() {
		if(eObject instanceof CriterionAttributeConfiguration){
			wizard = new SelectInfoElementWizard(eObject);
			WizardDialog wizardDialog = new WizardDialog(text.getShell(), wizard) {
				{
					// Initialization to allow the wizard to be non-modal
					setShellStyle(SWT.SHELL_TRIM);
				}
			};
			wizardDialog.create();
			wizardDialog.setBlockOnOpen(true);
			if (wizardDialog.open() == WizardDialog.OK) {
				
				EditingDomain editingDomain = ((DfmconfEditor) getPart()).getEditingDomain();
				Command command = SetCommand.create(editingDomain, eObject, getFeature(), wizard.getInfoElementUri());
				if (command.canExecute()) {
					editingDomain.getCommandStack().execute(command);
					text.setText(wizard.getInfoElementUri().toString());
				}
				// WORKS but need refactor (Command..)
				DocumentFeatureSelection dfs = (DocumentFeatureSelection) ((CriterionAttributeConfiguration) eObject).eContainer();
				if(dfs != null){
					while(dfs.getModelOwner() == null){
						DocumentFeatureSelection dfsAux = (DocumentFeatureSelection) dfs.eContainer();
						dfs = dfsAux;
					}
					DocumentFeatureModelConfiguration dfmc = dfs.getModelOwner();
					if(dfmc != null){
						for(VariableAttributeConfiguration vAttrCGlobal : dfmc.getGlobalVariableAttributes()){
							boolean isFound = false;
							for(Object vAttrcMapKey : wizard.getVarAttrRefMap().keySet()){
								VariableAttributeConfiguration vAttr = (VariableAttributeConfiguration) vAttrcMapKey;
								if(vAttrCGlobal.equals(vAttr)){
									vAttrCGlobal.getReferences().addAll((Collection<? extends Reference>) wizard.getVarAttrRefMap().get(vAttr));
									isFound = true;
								}
								if(isFound) break;
							}
						}
						for(DocumentFeatureSelection dfsAux : dfmc.getTopFeaturesSelection()){
							for(VariableAttributeConfiguration vAttrc : dfsAux.getVariableAttributesConfiguration()){
								boolean isFound = false;
								for(Object vAttrcMapKey : wizard.getVarAttrRefMap().keySet()){
									VariableAttributeConfiguration vAttr = (VariableAttributeConfiguration) vAttrcMapKey;
									if(vAttrc.equals(vAttr)){
										vAttrc.getReferences().addAll((Collection<? extends Reference>) wizard.getVarAttrRefMap().get(vAttr));
										isFound = true;
									}
									if(isFound) break;
								}
							}
							if(dfsAux.getChildrenSelection() != null) searchChilds(dfsAux.getChildrenSelection());
						}
					}
				}
			}
		}
	}

	

	private void searchChilds(EList<DocumentFeatureSelection> eList) {
		
		for(DocumentFeatureSelection dfsAux : eList){
			for(VariableAttributeConfiguration vAttrc : dfsAux.getVariableAttributesConfiguration()){
				boolean isFound = false;
				for(Object vAttrcMapKey : wizard.getVarAttrRefMap().keySet()){
					VariableAttributeConfiguration vAttr = (VariableAttributeConfiguration) vAttrcMapKey;
					if(vAttrc.equals(vAttr)){
						vAttrc.getReferences().addAll((Collection<? extends Reference>) wizard.getVarAttrRefMap().get(vAttr));
						isFound = true;
					}
					if(isFound) break;
				}
			}
			searchChilds(dfsAux.getChildrenSelection());
		}
	}

	@Override
	public boolean shouldUseExtraSpace() {
		return true;
	}
	
	protected EAttribute getFeature() {
		return DfmconfPackage.eINSTANCE.getCriterionAttributeConfiguration_InfoElementURICandidate();
	}
	
	@Override
	public void setInput(IWorkbenchPart part, ISelection selection) {
		super.setInput(part, selection);
		if (text != null && getFeatureValue() != null) {
			text.setText(getFeatureValue().toString());
		}
	}
	
	@SuppressWarnings("unchecked")
	protected URI getFeatureValue() {
		return (URI) eObject.eGet(getFeature());
	}
}
