package es.upv.dsic.issi.dplfw.dfmconf.presentation.properties;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

import es.upv.dsic.issi.dplfw.dfmconf.presentation.DfmconfEditor;

public class DfmconfPropertySheetPage extends TabbedPropertySheetPage {

	/**
	 * The DFM editor
	 */
	protected DfmconfEditor editor;
	
	/**
	 * Constructor for this property sheet page.
	 * 
	 * @param editor
	 *            the editor contributor of the property sheet page.
	 */
	public DfmconfPropertySheetPage(DfmconfEditor editor) {
		super(editor);
		this.editor = editor;
	}
	
	/**
	 * Get the EMF AdapterFactory for this editor.
	 * 
	 * @return the EMF AdapterFactory for this editor.
	 */
	public DfmconfEditor getEditor() {
		return editor;
	}

	/**
	 * Get the EMF AdapterFactory for this editor.
	 * 
	 * @return the EMF AdapterFactory for this editor.
	 */
	public AdapterFactory getAdapterFactory() {
		return editor.getAdapterFactory();
	}

}
