package es.upv.dsic.issi.dplfw.dfmconf.presentation.actions;

import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.StatusManager;

import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.exceptions.FeatureModelNotFoundException;
import es.upv.dsic.issi.dplfw.dfmconf.presentation.DfmconfEditorPlugin;

public class ReconcileAction extends Action implements ISelectionChangedListener{

	protected EObject selectedElement;
	
	private EditingDomain domain;
	
	public ReconcileAction(String string) {
		super(string);
	}

	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		IStructuredSelection selection = (IStructuredSelection) event.getSelection();
		if (selection.getFirstElement() instanceof EObject) {
			selectedElement = (EObject) selection.getFirstElement();
		} else {
			selectedElement = null;
		}
	}
	
	@Override
	public boolean isEnabled() {
		return (selectedElement instanceof DocumentFeatureModelConfiguration);
	}
	
	@Override
	public void run() {
		class ReconcileCommand extends ChangeCommand {

			private DocumentFeatureModelConfiguration dfmc;
			
			protected ReconcileCommand(DocumentFeatureModelConfiguration dfmc) {
				super(new ChangeRecorder(), dfmc);
				this.dfmc = dfmc;
			}

			@Override
			protected void doExecute() {
				try {
					dfmc.reconcile();
				} catch (FeatureModelNotFoundException e) {
					StatusManager.getManager().handle(
							new Status(Status.ERROR, DfmconfEditorPlugin.PLUGIN_ID, e.getLocalizedMessage(), e),
							StatusManager.BLOCK | StatusManager.LOG);
				}
			}
			@Override
			public String getLabel() {
				return "Reconcile";
			}
		}
		
		if (selectedElement instanceof DocumentFeatureModelConfiguration) {
			Command command = new ReconcileCommand((DocumentFeatureModelConfiguration) selectedElement);
			domain.getCommandStack().execute(command);
		}
	}

	public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
		setEditingDomain(workbenchPart instanceof IEditingDomainProvider ? 
				((IEditingDomainProvider) workbenchPart).getEditingDomain() : null);
	}
	  
	/**
	 * This returns the action's domain.
	 */
	public EditingDomain getEditingDomain() {
		return domain;
	}

	/**
	 * This sets the action's domain.
	 */
	public void setEditingDomain(EditingDomain domain) {
		this.domain = domain;
	}
}
