package es.upv.dsic.issi.dplfw.dfmconf.presentation;

import java.util.List;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;

public class ContextViewerFilter extends ViewerFilter {
	
	private boolean withoutContexts;
	private DocumentFeatureModelConfiguration dfmconf;
	
	public ContextViewerFilter(boolean withoutContexts) {
		this.withoutContexts = withoutContexts;
	}
	@Override
	public boolean select(Viewer viewer, Object parentElement, Object element) {
		if (this.dfmconf == null && element instanceof DocumentFeatureModelConfiguration) {
			this.dfmconf = (DocumentFeatureModelConfiguration) element;
		}
		if (element instanceof DocumentFeatureModelConfiguration) {
			return true;
		}else if (element instanceof DocumentFeatureSelection){
			DocumentFeatureSelection dfs = (DocumentFeatureSelection) element;
			List<DocumentContext> contexts = dfmconf.getSelectedContexts();
			for (DocumentContext context : dfs.getDocumentFeature().getDocumentContext()) {
				if (!contexts.contains(context)) {
					return false;
				} else {
					return true;
				}
			}
		}	
		if (withoutContexts){
			return true;
		}else {
			return false; 
		}
	}

	
}