/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfmconf.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfmconf.DfmconfPackage;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;

/**
 * This is the item provider adapter for a {@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DocumentFeatureSelectionItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DocumentFeatureSelectionItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addDocumentFeaturePropertyDescriptor(object);
			addSelectedPropertyDescriptor(object);
			addRequiresPropertyDescriptor(object);
			addExcludesPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Document Feature feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDocumentFeaturePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_DocumentFeatureSelection_documentFeature_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_DocumentFeatureSelection_documentFeature_feature", "_UI_DocumentFeatureSelection_type"),
				 DfmconfPackage.Literals.DOCUMENT_FEATURE_SELECTION__DOCUMENT_FEATURE,
				 false,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Selected feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSelectedPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_DocumentFeatureSelection_selected_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_DocumentFeatureSelection_selected_feature", "_UI_DocumentFeatureSelection_type"),
				 DfmconfPackage.Literals.DOCUMENT_FEATURE_SELECTION__SELECTED,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Requires feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addRequiresPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_DocumentFeatureSelection_requires_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_DocumentFeatureSelection_requires_feature", "_UI_DocumentFeatureSelection_type"),
				 DfmconfPackage.Literals.DOCUMENT_FEATURE_SELECTION__REQUIRES,
				 false,
				 false,
				 false,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Excludes feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addExcludesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_DocumentFeatureSelection_excludes_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_DocumentFeatureSelection_excludes_feature", "_UI_DocumentFeatureSelection_type"),
				 DfmconfPackage.Literals.DOCUMENT_FEATURE_SELECTION__EXCLUDES,
				 false,
				 false,
				 false,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(DfmconfPackage.Literals.DOCUMENT_FEATURE_SELECTION__CHILDREN_SELECTION);
			childrenFeatures.add(DfmconfPackage.Literals.DOCUMENT_FEATURE_SELECTION__VARIABLE_ATTRIBUTES_CONFIGURATION);
			childrenFeatures.add(DfmconfPackage.Literals.DOCUMENT_FEATURE_SELECTION__CRITERION_ATTRIBUTES_CONFIGURATION);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns DocumentFeatureSelection.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	@Override
	public Object getImage(Object object) {
		DocumentFeatureSelection documentFeatureSelection = (DocumentFeatureSelection)object;
		DocumentFeature feature = (DocumentFeature) documentFeatureSelection.getDocumentFeature();
		if (feature != null) {
			return DfmconfEditPlugin.getDfmLabelProvider().getImage(feature);
		} else {
			return overlayImage(object, getResourceLocator().getImage("full/obj16/DocumentFeatureSelection"));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean shouldComposeCreationImage() {
		return true;
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	@Override
	public String getText(Object object) {
		DocumentFeatureSelection documentFeatureSelection = (DocumentFeatureSelection)object;
		DocumentFeature feature = (DocumentFeature) documentFeatureSelection.getDocumentFeature();
		if (feature != null) {
			return DfmconfEditPlugin.getDfmLabelProvider().getText(feature);
		} else {
			return getString("_UI_DocumentFeatureSelection_type") + " " + documentFeatureSelection.getSelected();
		}
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(DocumentFeatureSelection.class)) {
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__SELECTED:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CHILDREN_SELECTION:
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__VARIABLE_ATTRIBUTES_CONFIGURATION:
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CRITERION_ATTRIBUTES_CONFIGURATION:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return DfmconfEditPlugin.INSTANCE;
	}

}
