/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfmconf.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfmconf.DfmconfFactory;
import es.upv.dsic.issi.dplfw.dfmconf.DfmconfPackage;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration;

/**
 * This is the item provider adapter for a {@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DocumentFeatureModelConfigurationItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider, IStructuredItemContentProvider, ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DocumentFeatureModelConfigurationItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addDocumentFeatureModelPropertyDescriptor(object);
			addDocumentFeatureModelURIPropertyDescriptor(object);
			addSelectedContextsPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Document Feature Model feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDocumentFeatureModelPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_DocumentFeatureModelConfiguration_documentFeatureModel_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_DocumentFeatureModelConfiguration_documentFeatureModel_feature", "_UI_DocumentFeatureModelConfiguration_type"),
				 DfmconfPackage.Literals.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL,
				 false,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Document Feature Model URI feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDocumentFeatureModelURIPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_DocumentFeatureModelConfiguration_documentFeatureModelURI_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_DocumentFeatureModelConfiguration_documentFeatureModelURI_feature", "_UI_DocumentFeatureModelConfiguration_type"),
				 DfmconfPackage.Literals.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL_URI,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Selected Contexts feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSelectedContextsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_DocumentFeatureModelConfiguration_selectedContexts_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_DocumentFeatureModelConfiguration_selectedContexts_feature", "_UI_DocumentFeatureModelConfiguration_type"),
				 DfmconfPackage.Literals.DOCUMENT_FEATURE_MODEL_CONFIGURATION__SELECTED_CONTEXTS,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(DfmconfPackage.Literals.DOCUMENT_FEATURE_MODEL_CONFIGURATION__TOP_FEATURES_SELECTION);
			childrenFeatures.add(DfmconfPackage.Literals.DOCUMENT_FEATURE_MODEL_CONFIGURATION__GLOBAL_VARIABLE_ATTRIBUTES);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns DocumentFeatureModelConfiguration.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	@Override
	public Object getImage(Object object) {
		DocumentFeatureModelConfiguration documentFeatureModelConfiguration = (DocumentFeatureModelConfiguration)object;
		DocumentFeatureModel featureModel = (DocumentFeatureModel) documentFeatureModelConfiguration.getDocumentFeatureModel();
		if (featureModel != null) {
			return DfmconfEditPlugin.getDfmLabelProvider().getImage(featureModel);
		} else {
			return overlayImage(object, getResourceLocator().getImage("full/obj16/DocumentFeatureModelConfiguration"));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean shouldComposeCreationImage() {
		return true;
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	@Override
	public String getText(Object object) {
		DocumentFeatureModelConfiguration documentFeatureModelConfiguration = (DocumentFeatureModelConfiguration)object;
		DocumentFeatureModel featureModel = (DocumentFeatureModel) documentFeatureModelConfiguration.getDocumentFeatureModel();
		if (featureModel != null) {
			return DfmconfEditPlugin.getDfmLabelProvider().getText(featureModel);
		} else {
			return getString("_UI_DocumentFeatureModelConfiguration_type");
		}
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(DocumentFeatureModelConfiguration.class)) {
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL_URI:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__TOP_FEATURES_SELECTION:
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__GLOBAL_VARIABLE_ATTRIBUTES:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(DfmconfPackage.Literals.DOCUMENT_FEATURE_MODEL_CONFIGURATION__GLOBAL_VARIABLE_ATTRIBUTES,
				 DfmconfFactory.eINSTANCE.createVariableAttributeConfiguration()));
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return DfmconfEditPlugin.INSTANCE;
	}

}
