/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfmconf.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import es.upv.dsic.issi.dplfw.dfmconf.util.DfmconfAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DfmconfItemProviderAdapterFactory extends DfmconfAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DfmconfItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentFeatureModelConfigurationItemProvider documentFeatureModelConfigurationItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDocumentFeatureModelConfigurationAdapter() {
		if (documentFeatureModelConfigurationItemProvider == null) {
			documentFeatureModelConfigurationItemProvider = new DocumentFeatureModelConfigurationItemProvider(this);
		}

		return documentFeatureModelConfigurationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentFeatureSelectionItemProvider documentFeatureSelectionItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDocumentFeatureSelectionAdapter() {
		if (documentFeatureSelectionItemProvider == null) {
			documentFeatureSelectionItemProvider = new DocumentFeatureSelectionItemProvider(this);
		}

		return documentFeatureSelectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfmconf.RequiresSelection} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RequiresSelectionItemProvider requiresSelectionItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfmconf.RequiresSelection}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRequiresSelectionAdapter() {
		if (requiresSelectionItemProvider == null) {
			requiresSelectionItemProvider = new RequiresSelectionItemProvider(this);
		}

		return requiresSelectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfmconf.ExcludesSelection} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExcludesSelectionItemProvider excludesSelectionItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfmconf.ExcludesSelection}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExcludesSelectionAdapter() {
		if (excludesSelectionItemProvider == null) {
			excludesSelectionItemProvider = new ExcludesSelectionItemProvider(this);
		}

		return excludesSelectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfmconf.VariableAttributeConfiguration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableAttributeConfigurationItemProvider variableAttributeConfigurationItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfmconf.VariableAttributeConfiguration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableAttributeConfigurationAdapter() {
		if (variableAttributeConfigurationItemProvider == null) {
			variableAttributeConfigurationItemProvider = new VariableAttributeConfigurationItemProvider(this);
		}

		return variableAttributeConfigurationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfmconf.CriterionAttributeConfiguration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CriterionAttributeConfigurationItemProvider criterionAttributeConfigurationItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfmconf.CriterionAttributeConfiguration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCriterionAttributeConfigurationAdapter() {
		if (criterionAttributeConfigurationItemProvider == null) {
			criterionAttributeConfigurationItemProvider = new CriterionAttributeConfigurationItemProvider(this);
		}

		return criterionAttributeConfigurationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfmconf.Criterion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CriterionItemProvider criterionItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfmconf.Criterion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCriterionAdapter() {
		if (criterionItemProvider == null) {
			criterionItemProvider = new CriterionItemProvider(this);
		}

		return criterionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfmconf.Reference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReferenceItemProvider referenceItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfmconf.Reference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenceAdapter() {
		if (referenceItemProvider == null) {
			referenceItemProvider = new ReferenceItemProvider(this);
		}

		return referenceItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (documentFeatureModelConfigurationItemProvider != null) documentFeatureModelConfigurationItemProvider.dispose();
		if (documentFeatureSelectionItemProvider != null) documentFeatureSelectionItemProvider.dispose();
		if (requiresSelectionItemProvider != null) requiresSelectionItemProvider.dispose();
		if (excludesSelectionItemProvider != null) excludesSelectionItemProvider.dispose();
		if (variableAttributeConfigurationItemProvider != null) variableAttributeConfigurationItemProvider.dispose();
		if (criterionAttributeConfigurationItemProvider != null) criterionAttributeConfigurationItemProvider.dispose();
		if (criterionItemProvider != null) criterionItemProvider.dispose();
		if (referenceItemProvider != null) referenceItemProvider.dispose();
	}

}
