/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm.util;

import es.upv.dsic.issi.dplfw.dfm.Annotation;
import es.upv.dsic.issi.dplfw.dfm.AnnotationEntry;
import es.upv.dsic.issi.dplfw.dfm.Attribute;
import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.Criterion;
import es.upv.dsic.issi.dplfw.dfm.CriterionAttribute;
import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.ExcludesFeature;
import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfm.MetadataElement;
import es.upv.dsic.issi.dplfw.dfm.Reference;
import es.upv.dsic.issi.dplfw.dfm.RequiresFeature;
import es.upv.dsic.issi.dplfw.dfm.RestrictionType;
import es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.VariableAttribute;
import es.upv.dsic.issi.dplfw.dfm.VariableType;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class DfmValidator
extends EObjectValidator {
    public static final DfmValidator INSTANCE = new DfmValidator();
    public static final String DIAGNOSTIC_SOURCE = "es.upv.dsic.issi.dplfw.dfm";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return DfmPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateDocumentFeatureModel((DocumentFeatureModel)value, diagnostics, context);
            }
            case 1: {
                return this.validateDocumentFeature((DocumentFeature)value, diagnostics, context);
            }
            case 2: {
                return this.validateContentDocumentFeature((ContentDocumentFeature)value, diagnostics, context);
            }
            case 3: {
                return this.validateTechnologyDocumentFeature((TechnologyDocumentFeature)value, diagnostics, context);
            }
            case 4: {
                return this.validateAnnotation((Annotation)value, diagnostics, context);
            }
            case 5: {
                return this.validateAnnotationEntry((AnnotationEntry)value, diagnostics, context);
            }
            case 6: {
                return this.validateRequiresFeature((RequiresFeature)value, diagnostics, context);
            }
            case 7: {
                return this.validateExcludesFeature((ExcludesFeature)value, diagnostics, context);
            }
            case 8: {
                return this.validateDocumentContext((DocumentContext)value, diagnostics, context);
            }
            case 9: {
                return this.validateAttribute((Attribute)value, diagnostics, context);
            }
            case 10: {
                return this.validateReference((Reference)value, diagnostics, context);
            }
            case 11: {
                return this.validateVariableAttribute((VariableAttribute)value, diagnostics, context);
            }
            case 12: {
                return this.validateCriterionAttribute((CriterionAttribute)value, diagnostics, context);
            }
            case 13: {
                return this.validateCriterion((Criterion)value, diagnostics, context);
            }
            case 14: {
                return this.validateFeatureType((FeatureType)((Object)value), diagnostics, context);
            }
            case 15: {
                return this.validateRestrictionType((RestrictionType)((Object)value), diagnostics, context);
            }
            case 16: {
                return this.validateVariableType((VariableType)((Object)value), diagnostics, context);
            }
            case 17: {
                return this.validateMetadataElement((MetadataElement)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateDocumentFeatureModel(DocumentFeatureModel documentFeatureModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(documentFeatureModel, diagnostics, context);
    }

    public boolean validateDocumentFeature(DocumentFeature documentFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(documentFeature, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(documentFeature, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(documentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(documentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(documentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(documentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(documentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(documentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(documentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDocumentFeature_valid_identifier(documentFeature, diagnostics, context);
        }
        return result;
    }

    public boolean validateDocumentFeature_valid_identifier(DocumentFeature documentFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String idName = documentFeature.getIdName();
        if (idName != null && !idName.matches("[a-zA-Z][a-zA-Z0-9_]*")) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"valid_identifier", DfmValidator.getObjectLabel((EObject)documentFeature, context)}, new Object[]{documentFeature}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateContentDocumentFeature(ContentDocumentFeature contentDocumentFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(contentDocumentFeature, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(contentDocumentFeature, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(contentDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(contentDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(contentDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(contentDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(contentDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(contentDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(contentDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDocumentFeature_valid_identifier(contentDocumentFeature, diagnostics, context);
        }
        return result;
    }

    public boolean validateTechnologyDocumentFeature(TechnologyDocumentFeature technologyDocumentFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(technologyDocumentFeature, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(technologyDocumentFeature, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(technologyDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(technologyDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(technologyDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(technologyDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(technologyDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(technologyDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(technologyDocumentFeature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDocumentFeature_valid_identifier(technologyDocumentFeature, diagnostics, context);
        }
        return result;
    }

    public boolean validateAnnotation(Annotation annotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(annotation, diagnostics, context);
    }

    public boolean validateAnnotationEntry(AnnotationEntry annotationEntry, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(annotationEntry, diagnostics, context);
    }

    public boolean validateRequiresFeature(RequiresFeature requiresFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(requiresFeature, diagnostics, context);
    }

    public boolean validateExcludesFeature(ExcludesFeature excludesFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(excludesFeature, diagnostics, context);
    }

    public boolean validateDocumentContext(DocumentContext documentContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(documentContext, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(documentContext, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(documentContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(documentContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(documentContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(documentContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(documentContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(documentContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(documentContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDocumentContext_valid_identifier(documentContext, diagnostics, context);
        }
        return result;
    }

    public boolean validateDocumentContext_valid_identifier(DocumentContext documentContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = documentContext.getName();
        if (name != null && !name.matches("[a-zA-Z][a-zA-Z0-9_]*")) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"valid_identifier", DfmValidator.getObjectLabel((EObject)documentContext, context)}, new Object[]{documentContext}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateAttribute(Attribute attribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(attribute, diagnostics, context);
    }

    public boolean validateReference(Reference reference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(reference, diagnostics, context);
    }

    public boolean validateVariableAttribute(VariableAttribute variableAttribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(variableAttribute, diagnostics, context);
    }

    public boolean validateCriterionAttribute(CriterionAttribute criterionAttribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(criterionAttribute, diagnostics, context);
    }

    public boolean validateCriterion(Criterion criterion, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(criterion, diagnostics, context);
    }

    public boolean validateFeatureType(FeatureType featureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateRestrictionType(RestrictionType restrictionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateVariableType(VariableType variableType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateMetadataElement(MetadataElement metadataElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

