/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VariableType implements Enumerator
{
    STRING(0, "string", "string"),
    CHAR(4, "char", "char"),
    INTEGER(1, "integer", "integer"),
    FLOAT(3, "float", "float"),
    DOUBLE(2, "double", "double");

    public static final int STRING_VALUE = 0;
    public static final int CHAR_VALUE = 4;
    public static final int INTEGER_VALUE = 1;
    public static final int FLOAT_VALUE = 3;
    public static final int DOUBLE_VALUE = 2;
    private static final VariableType[] VALUES_ARRAY;
    public static final List<VariableType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VariableType[]{STRING, CHAR, INTEGER, FLOAT, DOUBLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VariableType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariableType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariableType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariableType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariableType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 4: {
                return CHAR;
            }
            case 1: {
                return INTEGER;
            }
            case 3: {
                return FLOAT;
            }
            case 2: {
                return DOUBLE;
            }
        }
        return null;
    }

    private VariableType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

