/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RestrictionType implements Enumerator
{
    OR(0, "or", "or"),
    AND(1, "and", "and");

    public static final int OR_VALUE = 0;
    public static final int AND_VALUE = 1;
    private static final RestrictionType[] VALUES_ARRAY;
    public static final List<RestrictionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RestrictionType[]{OR, AND};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RestrictionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RestrictionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RestrictionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RestrictionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RestrictionType get(int value) {
        switch (value) {
            case 0: {
                return OR;
            }
            case 1: {
                return AND;
            }
        }
        return null;
    }

    private RestrictionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

