/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MetadataElement implements Enumerator
{
    TITLE(0, "title", "title"),
    SUBJECT(1, "subject", "subject"),
    PUBLISHER(5, "publisher", "publisher"),
    LANGUAGE(6, "language", "language"),
    DESCRIPTION(2, "description", "description"),
    AUTHORS(4, "authors", "authors"),
    KEYWORDS(3, "keywords", "keywords"),
    DATA_CREATION(7, "dataCreation", "dataCreation"),
    DATA_INSERTION(8, "dataInsertion", "dataInsertion");

    public static final int TITLE_VALUE = 0;
    public static final int SUBJECT_VALUE = 1;
    public static final int PUBLISHER_VALUE = 5;
    public static final int LANGUAGE_VALUE = 6;
    public static final int DESCRIPTION_VALUE = 2;
    public static final int AUTHORS_VALUE = 4;
    public static final int KEYWORDS_VALUE = 3;
    public static final int DATA_CREATION_VALUE = 7;
    public static final int DATA_INSERTION_VALUE = 8;
    private static final MetadataElement[] VALUES_ARRAY;
    public static final List<MetadataElement> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MetadataElement[]{TITLE, SUBJECT, PUBLISHER, LANGUAGE, DESCRIPTION, AUTHORS, KEYWORDS, DATA_CREATION, DATA_INSERTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MetadataElement get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MetadataElement result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MetadataElement getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MetadataElement result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MetadataElement get(int value) {
        switch (value) {
            case 0: {
                return TITLE;
            }
            case 1: {
                return SUBJECT;
            }
            case 5: {
                return PUBLISHER;
            }
            case 6: {
                return LANGUAGE;
            }
            case 2: {
                return DESCRIPTION;
            }
            case 4: {
                return AUTHORS;
            }
            case 3: {
                return KEYWORDS;
            }
            case 7: {
                return DATA_CREATION;
            }
            case 8: {
                return DATA_INSERTION;
            }
        }
        return null;
    }

    private MetadataElement(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

