/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FeatureType implements Enumerator
{
    MANDATORY(0, "mandatory", "mandatory"),
    OPTIONAL(1, "optional", "optional"),
    ALTERNATIVE(2, "alternative", "alternative"),
    OR(3, "or", "or");

    public static final int MANDATORY_VALUE = 0;
    public static final int OPTIONAL_VALUE = 1;
    public static final int ALTERNATIVE_VALUE = 2;
    public static final int OR_VALUE = 3;
    private static final FeatureType[] VALUES_ARRAY;
    public static final List<FeatureType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FeatureType[]{MANDATORY, OPTIONAL, ALTERNATIVE, OR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FeatureType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FeatureType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FeatureType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FeatureType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FeatureType get(int value) {
        switch (value) {
            case 0: {
                return MANDATORY;
            }
            case 1: {
                return OPTIONAL;
            }
            case 2: {
                return ALTERNATIVE;
            }
            case 3: {
                return OR;
            }
        }
        return null;
    }

    private FeatureType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public String getSymbol() {
        switch (this.value) {
            case 0: {
                return "!";
            }
            case 1: {
                return "?";
            }
            case 2: {
                return "\u00b7";
            }
            case 3: {
                return ":";
            }
        }
        return "";
    }
}

