/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfm.util;

import java.util.Map;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

import es.upv.dsic.issi.dplfw.dfm.Annotation;
import es.upv.dsic.issi.dplfw.dfm.AnnotationEntry;
import es.upv.dsic.issi.dplfw.dfm.Attribute;
import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.Criterion;
import es.upv.dsic.issi.dplfw.dfm.CriterionAttribute;
import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.ExcludesFeature;
import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfm.MetadataElement;
import es.upv.dsic.issi.dplfw.dfm.Reference;
import es.upv.dsic.issi.dplfw.dfm.RequiresFeature;
import es.upv.dsic.issi.dplfw.dfm.RestrictionType;
import es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.VariableAttribute;
import es.upv.dsic.issi.dplfw.dfm.VariableType;


/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see es.upv.dsic.issi.dplfw.dfm.DfmPackage
 * @generated
 */
public class DfmValidator extends EObjectValidator {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final DfmValidator INSTANCE = new DfmValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "es.upv.dsic.issi.dplfw.dfm";

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DfmValidator() {
		super();
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage() {
	  return DfmPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
		switch (classifierID) {
			case DfmPackage.DOCUMENT_FEATURE_MODEL:
				return validateDocumentFeatureModel((DocumentFeatureModel)value, diagnostics, context);
			case DfmPackage.DOCUMENT_FEATURE:
				return validateDocumentFeature((DocumentFeature)value, diagnostics, context);
			case DfmPackage.CONTENT_DOCUMENT_FEATURE:
				return validateContentDocumentFeature((ContentDocumentFeature)value, diagnostics, context);
			case DfmPackage.TECHNOLOGY_DOCUMENT_FEATURE:
				return validateTechnologyDocumentFeature((TechnologyDocumentFeature)value, diagnostics, context);
			case DfmPackage.ANNOTATION:
				return validateAnnotation((Annotation)value, diagnostics, context);
			case DfmPackage.ANNOTATION_ENTRY:
				return validateAnnotationEntry((AnnotationEntry)value, diagnostics, context);
			case DfmPackage.REQUIRES_FEATURE:
				return validateRequiresFeature((RequiresFeature)value, diagnostics, context);
			case DfmPackage.EXCLUDES_FEATURE:
				return validateExcludesFeature((ExcludesFeature)value, diagnostics, context);
			case DfmPackage.DOCUMENT_CONTEXT:
				return validateDocumentContext((DocumentContext)value, diagnostics, context);
			case DfmPackage.ATTRIBUTE:
				return validateAttribute((Attribute)value, diagnostics, context);
			case DfmPackage.REFERENCE:
				return validateReference((Reference)value, diagnostics, context);
			case DfmPackage.VARIABLE_ATTRIBUTE:
				return validateVariableAttribute((VariableAttribute)value, diagnostics, context);
			case DfmPackage.CRITERION_ATTRIBUTE:
				return validateCriterionAttribute((CriterionAttribute)value, diagnostics, context);
			case DfmPackage.CRITERION:
				return validateCriterion((Criterion)value, diagnostics, context);
			case DfmPackage.FEATURE_TYPE:
				return validateFeatureType((FeatureType)value, diagnostics, context);
			case DfmPackage.RESTRICTION_TYPE:
				return validateRestrictionType((RestrictionType)value, diagnostics, context);
			case DfmPackage.VARIABLE_TYPE:
				return validateVariableType((VariableType)value, diagnostics, context);
			case DfmPackage.METADATA_ELEMENT:
				return validateMetadataElement((MetadataElement)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDocumentFeatureModel(DocumentFeatureModel documentFeatureModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(documentFeatureModel, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDocumentFeature(DocumentFeature documentFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(documentFeature, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(documentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(documentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(documentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(documentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(documentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(documentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(documentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(documentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validateDocumentFeature_valid_identifier(documentFeature, diagnostics, context);
		return result;
	}

	/**
	 * Validates the valid_identifier constraint of '<em>Document Feature</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public boolean validateDocumentFeature_valid_identifier(DocumentFeature documentFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
		String idName = documentFeature.getIdName();
		if (idName != null && 
				!idName.matches("[a-zA-Z][a-zA-Z0-9_]*")) {
			if (diagnostics != null) {
				diagnostics.add
					(createDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 "_UI_GenericConstraint_diagnostic",
						 new Object[] { "valid_identifier", getObjectLabel(documentFeature, context) },
						 new Object[] { documentFeature },
						 context));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateContentDocumentFeature(ContentDocumentFeature contentDocumentFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(contentDocumentFeature, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(contentDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(contentDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(contentDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(contentDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(contentDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(contentDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(contentDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(contentDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validateDocumentFeature_valid_identifier(contentDocumentFeature, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateTechnologyDocumentFeature(TechnologyDocumentFeature technologyDocumentFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(technologyDocumentFeature, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(technologyDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(technologyDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(technologyDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(technologyDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(technologyDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(technologyDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(technologyDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(technologyDocumentFeature, diagnostics, context);
		if (result || diagnostics != null) result &= validateDocumentFeature_valid_identifier(technologyDocumentFeature, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAnnotation(Annotation annotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(annotation, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAnnotationEntry(AnnotationEntry annotationEntry, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(annotationEntry, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateRequiresFeature(RequiresFeature requiresFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(requiresFeature, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateExcludesFeature(ExcludesFeature excludesFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(excludesFeature, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDocumentContext(DocumentContext documentContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(documentContext, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(documentContext, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(documentContext, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(documentContext, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(documentContext, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(documentContext, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(documentContext, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(documentContext, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(documentContext, diagnostics, context);
		if (result || diagnostics != null) result &= validateDocumentContext_valid_identifier(documentContext, diagnostics, context);
		return result;
	}

	/**
	 * Validates the valid_identifier constraint of '<em>Document Context</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public boolean validateDocumentContext_valid_identifier(DocumentContext documentContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
		String name = documentContext.getName();
		if (name != null && 
				!name.matches("[a-zA-Z][a-zA-Z0-9_]*")) {
			if (diagnostics != null) {
				diagnostics.add
					(createDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 "_UI_GenericConstraint_diagnostic",
						 new Object[] { "valid_identifier", getObjectLabel(documentContext, context) },
						 new Object[] { documentContext },
						 context));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAttribute(Attribute attribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(attribute, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateReference(Reference reference, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(reference, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateVariableAttribute(VariableAttribute variableAttribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(variableAttribute, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCriterionAttribute(CriterionAttribute criterionAttribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(criterionAttribute, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCriterion(Criterion criterion, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(criterion, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateFeatureType(FeatureType featureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateRestrictionType(RestrictionType restrictionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateVariableType(VariableType variableType, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMetadataElement(MetadataElement metadataElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return true;
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //DfmValidator
