/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfm.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.VariableAttribute;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Document Feature Model</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureModelImpl#getName <em>Name</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureModelImpl#getFeatures <em>Features</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureModelImpl#getContexts <em>Contexts</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureModelImpl#getGlobalVariableAttribute <em>Global Variable Attribute</em>}</li>
 * </ul>
 *
 * @generated
 */
public class DocumentFeatureModelImpl extends EObjectImpl implements DocumentFeatureModel {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getFeatures() <em>Features</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFeatures()
	 * @generated
	 * @ordered
	 */
	protected EList<DocumentFeature> features;

	/**
	 * The cached value of the '{@link #getContexts() <em>Contexts</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContexts()
	 * @generated
	 * @ordered
	 */
	protected EList<DocumentContext> contexts;

	/**
	 * The cached value of the '{@link #getGlobalVariableAttribute() <em>Global Variable Attribute</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGlobalVariableAttribute()
	 * @generated
	 * @ordered
	 */
	protected EList<VariableAttribute> globalVariableAttribute;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentFeatureModelImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DfmPackage.Literals.DOCUMENT_FEATURE_MODEL;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DocumentFeature> getFeatures() {
		if (features == null) {
			features = new EObjectContainmentEList<DocumentFeature>(DocumentFeature.class, this, DfmPackage.DOCUMENT_FEATURE_MODEL__FEATURES);
		}
		return features;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DocumentContext> getContexts() {
		if (contexts == null) {
			contexts = new EObjectContainmentEList<DocumentContext>(DocumentContext.class, this, DfmPackage.DOCUMENT_FEATURE_MODEL__CONTEXTS);
		}
		return contexts;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<VariableAttribute> getGlobalVariableAttribute() {
		if (globalVariableAttribute == null) {
			globalVariableAttribute = new EObjectContainmentEList<VariableAttribute>(VariableAttribute.class, this, DfmPackage.DOCUMENT_FEATURE_MODEL__GLOBAL_VARIABLE_ATTRIBUTE);
		}
		return globalVariableAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmPackage.DOCUMENT_FEATURE_MODEL__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DfmPackage.DOCUMENT_FEATURE_MODEL__FEATURES:
				return ((InternalEList<?>)getFeatures()).basicRemove(otherEnd, msgs);
			case DfmPackage.DOCUMENT_FEATURE_MODEL__CONTEXTS:
				return ((InternalEList<?>)getContexts()).basicRemove(otherEnd, msgs);
			case DfmPackage.DOCUMENT_FEATURE_MODEL__GLOBAL_VARIABLE_ATTRIBUTE:
				return ((InternalEList<?>)getGlobalVariableAttribute()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DfmPackage.DOCUMENT_FEATURE_MODEL__NAME:
				return getName();
			case DfmPackage.DOCUMENT_FEATURE_MODEL__FEATURES:
				return getFeatures();
			case DfmPackage.DOCUMENT_FEATURE_MODEL__CONTEXTS:
				return getContexts();
			case DfmPackage.DOCUMENT_FEATURE_MODEL__GLOBAL_VARIABLE_ATTRIBUTE:
				return getGlobalVariableAttribute();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DfmPackage.DOCUMENT_FEATURE_MODEL__NAME:
				setName((String)newValue);
				return;
			case DfmPackage.DOCUMENT_FEATURE_MODEL__FEATURES:
				getFeatures().clear();
				getFeatures().addAll((Collection<? extends DocumentFeature>)newValue);
				return;
			case DfmPackage.DOCUMENT_FEATURE_MODEL__CONTEXTS:
				getContexts().clear();
				getContexts().addAll((Collection<? extends DocumentContext>)newValue);
				return;
			case DfmPackage.DOCUMENT_FEATURE_MODEL__GLOBAL_VARIABLE_ATTRIBUTE:
				getGlobalVariableAttribute().clear();
				getGlobalVariableAttribute().addAll((Collection<? extends VariableAttribute>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DfmPackage.DOCUMENT_FEATURE_MODEL__NAME:
				setName(NAME_EDEFAULT);
				return;
			case DfmPackage.DOCUMENT_FEATURE_MODEL__FEATURES:
				getFeatures().clear();
				return;
			case DfmPackage.DOCUMENT_FEATURE_MODEL__CONTEXTS:
				getContexts().clear();
				return;
			case DfmPackage.DOCUMENT_FEATURE_MODEL__GLOBAL_VARIABLE_ATTRIBUTE:
				getGlobalVariableAttribute().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DfmPackage.DOCUMENT_FEATURE_MODEL__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case DfmPackage.DOCUMENT_FEATURE_MODEL__FEATURES:
				return features != null && !features.isEmpty();
			case DfmPackage.DOCUMENT_FEATURE_MODEL__CONTEXTS:
				return contexts != null && !contexts.isEmpty();
			case DfmPackage.DOCUMENT_FEATURE_MODEL__GLOBAL_VARIABLE_ATTRIBUTE:
				return globalVariableAttribute != null && !globalVariableAttribute.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //DocumentFeatureModelImpl
