/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfm.impl;

import java.text.Normalizer;
import java.text.Normalizer.Form;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import es.upv.dsic.issi.dplfw.dfm.Annotation;
import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.ExcludesFeature;
import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfm.RequiresFeature;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Document Feature</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureImpl#getVisibleName <em>Visible Name</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureImpl#getIdName <em>Id Name</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureImpl#getType <em>Type</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureImpl#getRequires <em>Requires</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureImpl#getExcludes <em>Excludes</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureImpl#getIsRequiredBy <em>Is Required By</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureImpl#getIsExcludedBy <em>Is Excluded By</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureImpl#getAnnotations <em>Annotations</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureImpl#getDocumentContext <em>Document Context</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class DocumentFeatureImpl extends EObjectImpl implements DocumentFeature {
	/**
	 * The default value of the '{@link #getVisibleName() <em>Visible Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibleName()
	 * @generated
	 * @ordered
	 */
	protected static final String VISIBLE_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVisibleName() <em>Visible Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibleName()
	 * @generated
	 * @ordered
	 */
	protected String visibleName = VISIBLE_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getIdName() <em>Id Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdName()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIdName() <em>Id Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdName()
	 * @generated
	 * @ordered
	 */
	protected String idName = ID_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final FeatureType TYPE_EDEFAULT = FeatureType.MANDATORY;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected FeatureType type = TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getRequires() <em>Requires</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRequires()
	 * @generated
	 * @ordered
	 */
	protected EList<RequiresFeature> requires;

	/**
	 * The cached value of the '{@link #getExcludes() <em>Excludes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExcludes()
	 * @generated
	 * @ordered
	 */
	protected EList<ExcludesFeature> excludes;

	/**
	 * The cached value of the '{@link #getIsRequiredBy() <em>Is Required By</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsRequiredBy()
	 * @generated
	 * @ordered
	 */
	protected EList<RequiresFeature> isRequiredBy;

	/**
	 * The cached value of the '{@link #getIsExcludedBy() <em>Is Excluded By</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsExcludedBy()
	 * @generated
	 * @ordered
	 */
	protected EList<ExcludesFeature> isExcludedBy;

	/**
	 * The cached value of the '{@link #getAnnotations() <em>Annotations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnnotations()
	 * @generated
	 * @ordered
	 */
	protected EList<Annotation> annotations;

	/**
	 * The cached value of the '{@link #getDocumentContext() <em>Document Context</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDocumentContext()
	 * @generated
	 * @ordered
	 */
	protected EList<DocumentContext> documentContext;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentFeatureImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DfmPackage.Literals.DOCUMENT_FEATURE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getIdName() {
		return idName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIdName(String newIdName) {
		String oldIdName = idName;
		idName = newIdName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmPackage.DOCUMENT_FEATURE__ID_NAME, oldIdName, idName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FeatureType getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setType(FeatureType newType) {
		FeatureType oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmPackage.DOCUMENT_FEATURE__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RequiresFeature> getRequires() {
		if (requires == null) {
			requires = new EObjectContainmentWithInverseEList<RequiresFeature>(RequiresFeature.class, this, DfmPackage.DOCUMENT_FEATURE__REQUIRES, DfmPackage.REQUIRES_FEATURE__OWNER_FEATURE);
		}
		return requires;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ExcludesFeature> getExcludes() {
		if (excludes == null) {
			excludes = new EObjectContainmentWithInverseEList<ExcludesFeature>(ExcludesFeature.class, this, DfmPackage.DOCUMENT_FEATURE__EXCLUDES, DfmPackage.EXCLUDES_FEATURE__OWNER_FEATURE);
		}
		return excludes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getVisibleName() {
		return visibleName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVisibleName(String newVisibleName) {
		String oldVisibleName = visibleName;
		visibleName = newVisibleName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmPackage.DOCUMENT_FEATURE__VISIBLE_NAME, oldVisibleName, visibleName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RequiresFeature> getIsRequiredBy() {
		if (isRequiredBy == null) {
			isRequiredBy = new EObjectWithInverseResolvingEList.ManyInverse<RequiresFeature>(RequiresFeature.class, this, DfmPackage.DOCUMENT_FEATURE__IS_REQUIRED_BY, DfmPackage.REQUIRES_FEATURE__CANDIDATES);
		}
		return isRequiredBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ExcludesFeature> getIsExcludedBy() {
		if (isExcludedBy == null) {
			isExcludedBy = new EObjectWithInverseResolvingEList.ManyInverse<ExcludesFeature>(ExcludesFeature.class, this, DfmPackage.DOCUMENT_FEATURE__IS_EXCLUDED_BY, DfmPackage.EXCLUDES_FEATURE__CANDIDATES);
		}
		return isExcludedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DfmPackage.DOCUMENT_FEATURE__REQUIRES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getRequires()).basicAdd(otherEnd, msgs);
			case DfmPackage.DOCUMENT_FEATURE__EXCLUDES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getExcludes()).basicAdd(otherEnd, msgs);
			case DfmPackage.DOCUMENT_FEATURE__IS_REQUIRED_BY:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getIsRequiredBy()).basicAdd(otherEnd, msgs);
			case DfmPackage.DOCUMENT_FEATURE__IS_EXCLUDED_BY:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getIsExcludedBy()).basicAdd(otherEnd, msgs);
			case DfmPackage.DOCUMENT_FEATURE__DOCUMENT_CONTEXT:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getDocumentContext()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Annotation> getAnnotations() {
		if (annotations == null) {
			annotations = new EObjectContainmentEList<Annotation>(Annotation.class, this, DfmPackage.DOCUMENT_FEATURE__ANNOTATIONS);
		}
		return annotations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DocumentContext> getDocumentContext() {
		if (documentContext == null) {
			documentContext = new EObjectWithInverseResolvingEList.ManyInverse<DocumentContext>(DocumentContext.class, this, DfmPackage.DOCUMENT_FEATURE__DOCUMENT_CONTEXT, DfmPackage.DOCUMENT_CONTEXT__CANDIDATES);
		}
		return documentContext;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	@Override
	public String computeIdName() {
		// BEGIN - Code to remove diacritics and extended chars
		String normalizedVisibleName = visibleName == null ? "" : Normalizer.normalize(visibleName, Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
		// END
		Matcher m = Pattern.compile("\\b(\\w)(\\w*)\\b").matcher(normalizedVisibleName);
		StringBuilder sb = new StringBuilder();
		while (m.find()) {
			sb.append(m.group(1).toUpperCase());
			sb.append(m.group(2).toLowerCase());
		}
		/*
		 * Check if there is a previous object with the same ID If the ID collides with
		 * any previous ID, calculate a new one
		 */
		String originalId = sb.toString();
		String newId = originalId;
		if (eResource() != null) {
			int i = 0;
			EObject eObject = null;
			eObject = eResource().getEObject(newId);
			while (eObject != null && eObject != this) {
				i++;
				newId = originalId + "_" + i;
				eObject = eResource().getEObject(newId);
			}
		}
		return newId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DfmPackage.DOCUMENT_FEATURE__REQUIRES:
				return ((InternalEList<?>)getRequires()).basicRemove(otherEnd, msgs);
			case DfmPackage.DOCUMENT_FEATURE__EXCLUDES:
				return ((InternalEList<?>)getExcludes()).basicRemove(otherEnd, msgs);
			case DfmPackage.DOCUMENT_FEATURE__IS_REQUIRED_BY:
				return ((InternalEList<?>)getIsRequiredBy()).basicRemove(otherEnd, msgs);
			case DfmPackage.DOCUMENT_FEATURE__IS_EXCLUDED_BY:
				return ((InternalEList<?>)getIsExcludedBy()).basicRemove(otherEnd, msgs);
			case DfmPackage.DOCUMENT_FEATURE__ANNOTATIONS:
				return ((InternalEList<?>)getAnnotations()).basicRemove(otherEnd, msgs);
			case DfmPackage.DOCUMENT_FEATURE__DOCUMENT_CONTEXT:
				return ((InternalEList<?>)getDocumentContext()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DfmPackage.DOCUMENT_FEATURE__VISIBLE_NAME:
				return getVisibleName();
			case DfmPackage.DOCUMENT_FEATURE__ID_NAME:
				return getIdName();
			case DfmPackage.DOCUMENT_FEATURE__TYPE:
				return getType();
			case DfmPackage.DOCUMENT_FEATURE__REQUIRES:
				return getRequires();
			case DfmPackage.DOCUMENT_FEATURE__EXCLUDES:
				return getExcludes();
			case DfmPackage.DOCUMENT_FEATURE__IS_REQUIRED_BY:
				return getIsRequiredBy();
			case DfmPackage.DOCUMENT_FEATURE__IS_EXCLUDED_BY:
				return getIsExcludedBy();
			case DfmPackage.DOCUMENT_FEATURE__ANNOTATIONS:
				return getAnnotations();
			case DfmPackage.DOCUMENT_FEATURE__DOCUMENT_CONTEXT:
				return getDocumentContext();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DfmPackage.DOCUMENT_FEATURE__VISIBLE_NAME:
				setVisibleName((String)newValue);
				return;
			case DfmPackage.DOCUMENT_FEATURE__ID_NAME:
				setIdName((String)newValue);
				return;
			case DfmPackage.DOCUMENT_FEATURE__TYPE:
				setType((FeatureType)newValue);
				return;
			case DfmPackage.DOCUMENT_FEATURE__REQUIRES:
				getRequires().clear();
				getRequires().addAll((Collection<? extends RequiresFeature>)newValue);
				return;
			case DfmPackage.DOCUMENT_FEATURE__EXCLUDES:
				getExcludes().clear();
				getExcludes().addAll((Collection<? extends ExcludesFeature>)newValue);
				return;
			case DfmPackage.DOCUMENT_FEATURE__IS_REQUIRED_BY:
				getIsRequiredBy().clear();
				getIsRequiredBy().addAll((Collection<? extends RequiresFeature>)newValue);
				return;
			case DfmPackage.DOCUMENT_FEATURE__IS_EXCLUDED_BY:
				getIsExcludedBy().clear();
				getIsExcludedBy().addAll((Collection<? extends ExcludesFeature>)newValue);
				return;
			case DfmPackage.DOCUMENT_FEATURE__ANNOTATIONS:
				getAnnotations().clear();
				getAnnotations().addAll((Collection<? extends Annotation>)newValue);
				return;
			case DfmPackage.DOCUMENT_FEATURE__DOCUMENT_CONTEXT:
				getDocumentContext().clear();
				getDocumentContext().addAll((Collection<? extends DocumentContext>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DfmPackage.DOCUMENT_FEATURE__VISIBLE_NAME:
				setVisibleName(VISIBLE_NAME_EDEFAULT);
				return;
			case DfmPackage.DOCUMENT_FEATURE__ID_NAME:
				setIdName(ID_NAME_EDEFAULT);
				return;
			case DfmPackage.DOCUMENT_FEATURE__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case DfmPackage.DOCUMENT_FEATURE__REQUIRES:
				getRequires().clear();
				return;
			case DfmPackage.DOCUMENT_FEATURE__EXCLUDES:
				getExcludes().clear();
				return;
			case DfmPackage.DOCUMENT_FEATURE__IS_REQUIRED_BY:
				getIsRequiredBy().clear();
				return;
			case DfmPackage.DOCUMENT_FEATURE__IS_EXCLUDED_BY:
				getIsExcludedBy().clear();
				return;
			case DfmPackage.DOCUMENT_FEATURE__ANNOTATIONS:
				getAnnotations().clear();
				return;
			case DfmPackage.DOCUMENT_FEATURE__DOCUMENT_CONTEXT:
				getDocumentContext().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DfmPackage.DOCUMENT_FEATURE__VISIBLE_NAME:
				return VISIBLE_NAME_EDEFAULT == null ? visibleName != null : !VISIBLE_NAME_EDEFAULT.equals(visibleName);
			case DfmPackage.DOCUMENT_FEATURE__ID_NAME:
				return ID_NAME_EDEFAULT == null ? idName != null : !ID_NAME_EDEFAULT.equals(idName);
			case DfmPackage.DOCUMENT_FEATURE__TYPE:
				return type != TYPE_EDEFAULT;
			case DfmPackage.DOCUMENT_FEATURE__REQUIRES:
				return requires != null && !requires.isEmpty();
			case DfmPackage.DOCUMENT_FEATURE__EXCLUDES:
				return excludes != null && !excludes.isEmpty();
			case DfmPackage.DOCUMENT_FEATURE__IS_REQUIRED_BY:
				return isRequiredBy != null && !isRequiredBy.isEmpty();
			case DfmPackage.DOCUMENT_FEATURE__IS_EXCLUDED_BY:
				return isExcludedBy != null && !isExcludedBy.isEmpty();
			case DfmPackage.DOCUMENT_FEATURE__ANNOTATIONS:
				return annotations != null && !annotations.isEmpty();
			case DfmPackage.DOCUMENT_FEATURE__DOCUMENT_CONTEXT:
				return documentContext != null && !documentContext.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (visibleName: ");
		result.append(visibleName);
		result.append(", idName: ");
		result.append(idName);
		result.append(", type: ");
		result.append(type);
		result.append(')');
		return result.toString();
	}

} //DocumentFeatureImpl
