/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfm.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import es.upv.dsic.issi.dplfw.datatypes.DatatypesPackage;
import es.upv.dsic.issi.dplfw.dfm.Annotation;
import es.upv.dsic.issi.dplfw.dfm.AnnotationEntry;
import es.upv.dsic.issi.dplfw.dfm.Attribute;
import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.Criterion;
import es.upv.dsic.issi.dplfw.dfm.CriterionAttribute;
import es.upv.dsic.issi.dplfw.dfm.DfmFactory;
import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.ExcludesFeature;
import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfm.MetadataElement;
import es.upv.dsic.issi.dplfw.dfm.Reference;
import es.upv.dsic.issi.dplfw.dfm.RequiresFeature;
import es.upv.dsic.issi.dplfw.dfm.RestrictionType;
import es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.VariableAttribute;
import es.upv.dsic.issi.dplfw.dfm.VariableType;
import es.upv.dsic.issi.dplfw.dfm.util.DfmValidator;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class DfmPackageImpl extends EPackageImpl implements DfmPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass documentFeatureModelEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass documentFeatureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contentDocumentFeatureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass technologyDocumentFeatureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass annotationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass annotationEntryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass requiresFeatureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass excludesFeatureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass documentContextEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass attributeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass referenceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass variableAttributeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass criterionAttributeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass criterionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum featureTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum restrictionTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum variableTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum metadataElementEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see es.upv.dsic.issi.dplfw.dfm.DfmPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private DfmPackageImpl() {
		super(eNS_URI, DfmFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link DfmPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static DfmPackage init() {
		if (isInited) return (DfmPackage)EPackage.Registry.INSTANCE.getEPackage(DfmPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredDfmPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		DfmPackageImpl theDfmPackage = registeredDfmPackage instanceof DfmPackageImpl ? (DfmPackageImpl)registeredDfmPackage : new DfmPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		DatatypesPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theDfmPackage.createPackageContents();

		// Initialize created meta-data
		theDfmPackage.initializePackageContents();

		// Register package validator
		EValidator.Registry.INSTANCE.put
			(theDfmPackage,
			 new EValidator.Descriptor() {
				 @Override
				 public EValidator getEValidator() {
					 return DfmValidator.INSTANCE;
				 }
			 });

		// Mark meta-data to indicate it can't be changed
		theDfmPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(DfmPackage.eNS_URI, theDfmPackage);
		return theDfmPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getDocumentFeatureModel() {
		return documentFeatureModelEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getDocumentFeatureModel_Features() {
		return (EReference)documentFeatureModelEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getDocumentFeatureModel_Contexts() {
		return (EReference)documentFeatureModelEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getDocumentFeatureModel_GlobalVariableAttribute() {
		return (EReference)documentFeatureModelEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getDocumentFeatureModel_Name() {
		return (EAttribute)documentFeatureModelEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getDocumentFeature() {
		return documentFeatureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getDocumentFeature_IdName() {
		return (EAttribute)documentFeatureEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getDocumentFeature_Type() {
		return (EAttribute)documentFeatureEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getDocumentFeature_Requires() {
		return (EReference)documentFeatureEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getDocumentFeature_Excludes() {
		return (EReference)documentFeatureEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getDocumentFeature_VisibleName() {
		return (EAttribute)documentFeatureEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getDocumentFeature_IsRequiredBy() {
		return (EReference)documentFeatureEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getDocumentFeature_IsExcludedBy() {
		return (EReference)documentFeatureEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getDocumentFeature_Annotations() {
		return (EReference)documentFeatureEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getDocumentFeature_DocumentContext() {
		return (EReference)documentFeatureEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getContentDocumentFeature() {
		return contentDocumentFeatureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getContentDocumentFeature_Children() {
		return (EReference)contentDocumentFeatureEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getContentDocumentFeature_ProvidedBy() {
		return (EReference)contentDocumentFeatureEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getContentDocumentFeature_SearchCriterion() {
		return (EReference)contentDocumentFeatureEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getContentDocumentFeature_VariableAttributes() {
		return (EReference)contentDocumentFeatureEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContentDocumentFeature_InfoElementURI() {
		return (EAttribute)contentDocumentFeatureEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContentDocumentFeature_Responsible() {
		return (EAttribute)contentDocumentFeatureEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContentDocumentFeature_Editors() {
		return (EAttribute)contentDocumentFeatureEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContentDocumentFeature_Readers() {
		return (EAttribute)contentDocumentFeatureEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getTechnologyDocumentFeature() {
		return technologyDocumentFeatureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getTechnologyDocumentFeature_Children() {
		return (EReference)technologyDocumentFeatureEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getTechnologyDocumentFeature_Provides() {
		return (EReference)technologyDocumentFeatureEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAnnotation() {
		return annotationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAnnotation_Entries() {
		return (EReference)annotationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAnnotation_Name() {
		return (EAttribute)annotationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAnnotationEntry() {
		return annotationEntryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAnnotationEntry_Key() {
		return (EAttribute)annotationEntryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAnnotationEntry_Value() {
		return (EAttribute)annotationEntryEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRequiresFeature() {
		return requiresFeatureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRequiresFeature_Candidates() {
		return (EReference)requiresFeatureEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRequiresFeature_OwnerFeature() {
		return (EReference)requiresFeatureEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getExcludesFeature() {
		return excludesFeatureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getExcludesFeature_Candidates() {
		return (EReference)excludesFeatureEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getExcludesFeature_OwnerFeature() {
		return (EReference)excludesFeatureEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getDocumentContext() {
		return documentContextEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getDocumentContext_Name() {
		return (EAttribute)documentContextEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getDocumentContext_Description() {
		return (EAttribute)documentContextEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getDocumentContext_Candidates() {
		return (EReference)documentContextEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAttribute() {
		return attributeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAttribute_IdName() {
		return (EAttribute)attributeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAttribute_Description() {
		return (EAttribute)attributeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getReference() {
		return referenceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getReference_InfoElementURI() {
		return (EAttribute)referenceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getReference_ReferenceName() {
		return (EAttribute)referenceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getVariableAttribute() {
		return variableAttributeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getVariableAttribute_References() {
		return (EReference)variableAttributeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getVariableAttribute_Type() {
		return (EAttribute)variableAttributeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getCriterionAttribute() {
		return criterionAttributeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCriterionAttribute_Criteria() {
		return (EReference)criterionAttributeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getCriterion() {
		return criterionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCriterion_Value() {
		return (EAttribute)criterionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCriterion_MetadataElement() {
		return (EAttribute)criterionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getFeatureType() {
		return featureTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getRestrictionType() {
		return restrictionTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getVariableType() {
		return variableTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getMetadataElement() {
		return metadataElementEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DfmFactory getDfmFactory() {
		return (DfmFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		documentFeatureModelEClass = createEClass(DOCUMENT_FEATURE_MODEL);
		createEAttribute(documentFeatureModelEClass, DOCUMENT_FEATURE_MODEL__NAME);
		createEReference(documentFeatureModelEClass, DOCUMENT_FEATURE_MODEL__FEATURES);
		createEReference(documentFeatureModelEClass, DOCUMENT_FEATURE_MODEL__CONTEXTS);
		createEReference(documentFeatureModelEClass, DOCUMENT_FEATURE_MODEL__GLOBAL_VARIABLE_ATTRIBUTE);

		documentFeatureEClass = createEClass(DOCUMENT_FEATURE);
		createEAttribute(documentFeatureEClass, DOCUMENT_FEATURE__VISIBLE_NAME);
		createEAttribute(documentFeatureEClass, DOCUMENT_FEATURE__ID_NAME);
		createEAttribute(documentFeatureEClass, DOCUMENT_FEATURE__TYPE);
		createEReference(documentFeatureEClass, DOCUMENT_FEATURE__REQUIRES);
		createEReference(documentFeatureEClass, DOCUMENT_FEATURE__EXCLUDES);
		createEReference(documentFeatureEClass, DOCUMENT_FEATURE__IS_REQUIRED_BY);
		createEReference(documentFeatureEClass, DOCUMENT_FEATURE__IS_EXCLUDED_BY);
		createEReference(documentFeatureEClass, DOCUMENT_FEATURE__ANNOTATIONS);
		createEReference(documentFeatureEClass, DOCUMENT_FEATURE__DOCUMENT_CONTEXT);

		contentDocumentFeatureEClass = createEClass(CONTENT_DOCUMENT_FEATURE);
		createEAttribute(contentDocumentFeatureEClass, CONTENT_DOCUMENT_FEATURE__INFO_ELEMENT_URI);
		createEAttribute(contentDocumentFeatureEClass, CONTENT_DOCUMENT_FEATURE__RESPONSIBLE);
		createEAttribute(contentDocumentFeatureEClass, CONTENT_DOCUMENT_FEATURE__EDITORS);
		createEAttribute(contentDocumentFeatureEClass, CONTENT_DOCUMENT_FEATURE__READERS);
		createEReference(contentDocumentFeatureEClass, CONTENT_DOCUMENT_FEATURE__CHILDREN);
		createEReference(contentDocumentFeatureEClass, CONTENT_DOCUMENT_FEATURE__PROVIDED_BY);
		createEReference(contentDocumentFeatureEClass, CONTENT_DOCUMENT_FEATURE__SEARCH_CRITERION);
		createEReference(contentDocumentFeatureEClass, CONTENT_DOCUMENT_FEATURE__VARIABLE_ATTRIBUTES);

		technologyDocumentFeatureEClass = createEClass(TECHNOLOGY_DOCUMENT_FEATURE);
		createEReference(technologyDocumentFeatureEClass, TECHNOLOGY_DOCUMENT_FEATURE__CHILDREN);
		createEReference(technologyDocumentFeatureEClass, TECHNOLOGY_DOCUMENT_FEATURE__PROVIDES);

		annotationEClass = createEClass(ANNOTATION);
		createEReference(annotationEClass, ANNOTATION__ENTRIES);
		createEAttribute(annotationEClass, ANNOTATION__NAME);

		annotationEntryEClass = createEClass(ANNOTATION_ENTRY);
		createEAttribute(annotationEntryEClass, ANNOTATION_ENTRY__KEY);
		createEAttribute(annotationEntryEClass, ANNOTATION_ENTRY__VALUE);

		requiresFeatureEClass = createEClass(REQUIRES_FEATURE);
		createEReference(requiresFeatureEClass, REQUIRES_FEATURE__CANDIDATES);
		createEReference(requiresFeatureEClass, REQUIRES_FEATURE__OWNER_FEATURE);

		excludesFeatureEClass = createEClass(EXCLUDES_FEATURE);
		createEReference(excludesFeatureEClass, EXCLUDES_FEATURE__CANDIDATES);
		createEReference(excludesFeatureEClass, EXCLUDES_FEATURE__OWNER_FEATURE);

		documentContextEClass = createEClass(DOCUMENT_CONTEXT);
		createEAttribute(documentContextEClass, DOCUMENT_CONTEXT__NAME);
		createEAttribute(documentContextEClass, DOCUMENT_CONTEXT__DESCRIPTION);
		createEReference(documentContextEClass, DOCUMENT_CONTEXT__CANDIDATES);

		attributeEClass = createEClass(ATTRIBUTE);
		createEAttribute(attributeEClass, ATTRIBUTE__ID_NAME);
		createEAttribute(attributeEClass, ATTRIBUTE__DESCRIPTION);

		referenceEClass = createEClass(REFERENCE);
		createEAttribute(referenceEClass, REFERENCE__INFO_ELEMENT_URI);
		createEAttribute(referenceEClass, REFERENCE__REFERENCE_NAME);

		variableAttributeEClass = createEClass(VARIABLE_ATTRIBUTE);
		createEReference(variableAttributeEClass, VARIABLE_ATTRIBUTE__REFERENCES);
		createEAttribute(variableAttributeEClass, VARIABLE_ATTRIBUTE__TYPE);

		criterionAttributeEClass = createEClass(CRITERION_ATTRIBUTE);
		createEReference(criterionAttributeEClass, CRITERION_ATTRIBUTE__CRITERIA);

		criterionEClass = createEClass(CRITERION);
		createEAttribute(criterionEClass, CRITERION__VALUE);
		createEAttribute(criterionEClass, CRITERION__METADATA_ELEMENT);

		// Create enums
		featureTypeEEnum = createEEnum(FEATURE_TYPE);
		restrictionTypeEEnum = createEEnum(RESTRICTION_TYPE);
		variableTypeEEnum = createEEnum(VARIABLE_TYPE);
		metadataElementEEnum = createEEnum(METADATA_ELEMENT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		DatatypesPackage theDatatypesPackage = (DatatypesPackage)EPackage.Registry.INSTANCE.getEPackage(DatatypesPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		contentDocumentFeatureEClass.getESuperTypes().add(this.getDocumentFeature());
		technologyDocumentFeatureEClass.getESuperTypes().add(this.getDocumentFeature());
		variableAttributeEClass.getESuperTypes().add(this.getAttribute());
		criterionAttributeEClass.getESuperTypes().add(this.getAttribute());

		// Initialize classes and features; add operations and parameters
		initEClass(documentFeatureModelEClass, DocumentFeatureModel.class, "DocumentFeatureModel", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDocumentFeatureModel_Name(), ecorePackage.getEString(), "name", null, 1, 1, DocumentFeatureModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentFeatureModel_Features(), this.getDocumentFeature(), null, "features", null, 1, -1, DocumentFeatureModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentFeatureModel_Contexts(), this.getDocumentContext(), null, "contexts", null, 0, -1, DocumentFeatureModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentFeatureModel_GlobalVariableAttribute(), this.getVariableAttribute(), null, "globalVariableAttribute", null, 0, -1, DocumentFeatureModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(documentFeatureEClass, DocumentFeature.class, "DocumentFeature", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDocumentFeature_VisibleName(), ecorePackage.getEString(), "visibleName", null, 1, 1, DocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDocumentFeature_IdName(), ecorePackage.getEString(), "idName", null, 1, 1, DocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDocumentFeature_Type(), this.getFeatureType(), "type", null, 1, 1, DocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentFeature_Requires(), this.getRequiresFeature(), this.getRequiresFeature_OwnerFeature(), "requires", null, 0, -1, DocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentFeature_Excludes(), this.getExcludesFeature(), this.getExcludesFeature_OwnerFeature(), "excludes", null, 0, -1, DocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentFeature_IsRequiredBy(), this.getRequiresFeature(), this.getRequiresFeature_Candidates(), "isRequiredBy", null, 0, -1, DocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentFeature_IsExcludedBy(), this.getExcludesFeature(), this.getExcludesFeature_Candidates(), "isExcludedBy", null, 0, -1, DocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentFeature_Annotations(), this.getAnnotation(), null, "annotations", null, 0, -1, DocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentFeature_DocumentContext(), this.getDocumentContext(), this.getDocumentContext_Candidates(), "documentContext", null, 0, -1, DocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(documentFeatureEClass, ecorePackage.getEString(), "computeIdName", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(contentDocumentFeatureEClass, ContentDocumentFeature.class, "ContentDocumentFeature", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getContentDocumentFeature_InfoElementURI(), theDatatypesPackage.getURI(), "infoElementURI", null, 0, 1, ContentDocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContentDocumentFeature_Responsible(), theDatatypesPackage.getUUID(), "responsible", null, 0, 1, ContentDocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContentDocumentFeature_Editors(), theDatatypesPackage.getUUID(), "editors", null, 0, -1, ContentDocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContentDocumentFeature_Readers(), theDatatypesPackage.getUUID(), "readers", null, 0, -1, ContentDocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getContentDocumentFeature_Children(), this.getContentDocumentFeature(), null, "children", null, 0, -1, ContentDocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getContentDocumentFeature_ProvidedBy(), this.getTechnologyDocumentFeature(), this.getTechnologyDocumentFeature_Provides(), "providedBy", null, 0, -1, ContentDocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getContentDocumentFeature_SearchCriterion(), this.getCriterionAttribute(), null, "searchCriterion", null, 0, 1, ContentDocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getContentDocumentFeature_VariableAttributes(), this.getVariableAttribute(), null, "variableAttributes", null, 0, -1, ContentDocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(contentDocumentFeatureEClass, null, "propagateEditors", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(contentDocumentFeatureEClass, null, "propagateReaders", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(contentDocumentFeatureEClass, null, "propagateResponsible", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(contentDocumentFeatureEClass, null, "propagateAllPermissions", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(technologyDocumentFeatureEClass, TechnologyDocumentFeature.class, "TechnologyDocumentFeature", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getTechnologyDocumentFeature_Children(), this.getTechnologyDocumentFeature(), null, "children", null, 0, -1, TechnologyDocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTechnologyDocumentFeature_Provides(), this.getContentDocumentFeature(), this.getContentDocumentFeature_ProvidedBy(), "provides", null, 0, -1, TechnologyDocumentFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(annotationEClass, Annotation.class, "Annotation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAnnotation_Entries(), this.getAnnotationEntry(), null, "entries", null, 0, -1, Annotation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAnnotation_Name(), ecorePackage.getEString(), "name", null, 1, 1, Annotation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(annotationEntryEClass, AnnotationEntry.class, "AnnotationEntry", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAnnotationEntry_Key(), ecorePackage.getEString(), "key", null, 1, 1, AnnotationEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAnnotationEntry_Value(), ecorePackage.getEString(), "value", null, 0, 1, AnnotationEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(requiresFeatureEClass, RequiresFeature.class, "RequiresFeature", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRequiresFeature_Candidates(), this.getDocumentFeature(), this.getDocumentFeature_IsRequiredBy(), "candidates", null, 1, -1, RequiresFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRequiresFeature_OwnerFeature(), this.getDocumentFeature(), this.getDocumentFeature_Requires(), "ownerFeature", null, 1, 1, RequiresFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(excludesFeatureEClass, ExcludesFeature.class, "ExcludesFeature", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getExcludesFeature_Candidates(), this.getDocumentFeature(), this.getDocumentFeature_IsExcludedBy(), "candidates", null, 1, -1, ExcludesFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getExcludesFeature_OwnerFeature(), this.getDocumentFeature(), this.getDocumentFeature_Excludes(), "ownerFeature", null, 1, 1, ExcludesFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(documentContextEClass, DocumentContext.class, "DocumentContext", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDocumentContext_Name(), ecorePackage.getEString(), "name", null, 1, 1, DocumentContext.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDocumentContext_Description(), ecorePackage.getEString(), "description", null, 0, 1, DocumentContext.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentContext_Candidates(), this.getDocumentFeature(), this.getDocumentFeature_DocumentContext(), "candidates", null, 0, -1, DocumentContext.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(attributeEClass, Attribute.class, "Attribute", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAttribute_IdName(), ecorePackage.getEString(), "idName", null, 0, 1, Attribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAttribute_Description(), ecorePackage.getEString(), "description", null, 0, 1, Attribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(referenceEClass, Reference.class, "Reference", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getReference_InfoElementURI(), theDatatypesPackage.getURI(), "infoElementURI", null, 0, 1, Reference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getReference_ReferenceName(), ecorePackage.getEString(), "referenceName", null, 0, 1, Reference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(variableAttributeEClass, VariableAttribute.class, "VariableAttribute", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getVariableAttribute_References(), this.getReference(), null, "references", null, 1, -1, VariableAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getVariableAttribute_Type(), this.getVariableType(), "type", null, 0, 1, VariableAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(criterionAttributeEClass, CriterionAttribute.class, "CriterionAttribute", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCriterionAttribute_Criteria(), this.getCriterion(), null, "criteria", null, 1, -1, CriterionAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(criterionEClass, Criterion.class, "Criterion", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getCriterion_Value(), ecorePackage.getEString(), "value", null, 0, 1, Criterion.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCriterion_MetadataElement(), this.getMetadataElement(), "metadataElement", null, 0, 1, Criterion.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(featureTypeEEnum, FeatureType.class, "FeatureType");
		addEEnumLiteral(featureTypeEEnum, FeatureType.MANDATORY);
		addEEnumLiteral(featureTypeEEnum, FeatureType.OPTIONAL);
		addEEnumLiteral(featureTypeEEnum, FeatureType.ALTERNATIVE);
		addEEnumLiteral(featureTypeEEnum, FeatureType.OR);

		initEEnum(restrictionTypeEEnum, RestrictionType.class, "RestrictionType");
		addEEnumLiteral(restrictionTypeEEnum, RestrictionType.OR);
		addEEnumLiteral(restrictionTypeEEnum, RestrictionType.AND);

		initEEnum(variableTypeEEnum, VariableType.class, "VariableType");
		addEEnumLiteral(variableTypeEEnum, VariableType.STRING);
		addEEnumLiteral(variableTypeEEnum, VariableType.CHAR);
		addEEnumLiteral(variableTypeEEnum, VariableType.INTEGER);
		addEEnumLiteral(variableTypeEEnum, VariableType.FLOAT);
		addEEnumLiteral(variableTypeEEnum, VariableType.DOUBLE);

		initEEnum(metadataElementEEnum, MetadataElement.class, "MetadataElement");
		addEEnumLiteral(metadataElementEEnum, MetadataElement.TITLE);
		addEEnumLiteral(metadataElementEEnum, MetadataElement.SUBJECT);
		addEEnumLiteral(metadataElementEEnum, MetadataElement.PUBLISHER);
		addEEnumLiteral(metadataElementEEnum, MetadataElement.LANGUAGE);
		addEEnumLiteral(metadataElementEEnum, MetadataElement.DESCRIPTION);
		addEEnumLiteral(metadataElementEEnum, MetadataElement.AUTHORS);
		addEEnumLiteral(metadataElementEEnum, MetadataElement.KEYWORDS);
		addEEnumLiteral(metadataElementEEnum, MetadataElement.DATA_CREATION);
		addEEnumLiteral(metadataElementEEnum, MetadataElement.DATA_INSERTION);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/emf/2002/Ecore
		createEcoreAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/Ecore</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createEcoreAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/Ecore";
		addAnnotation
		  (documentFeatureEClass,
		   source,
		   new String[] {
			   "constraints", "valid_identifier"
		   });
		addAnnotation
		  (documentContextEClass,
		   source,
		   new String[] {
			   "constraints", "valid_identifier"
		   });
	}

} //DfmPackageImpl
