/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfm.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import es.upv.dsic.issi.dplfw.dfm.Annotation;
import es.upv.dsic.issi.dplfw.dfm.AnnotationEntry;
import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.Criterion;
import es.upv.dsic.issi.dplfw.dfm.CriterionAttribute;
import es.upv.dsic.issi.dplfw.dfm.DfmFactory;
import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.ExcludesFeature;
import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfm.MetadataElement;
import es.upv.dsic.issi.dplfw.dfm.Reference;
import es.upv.dsic.issi.dplfw.dfm.RequiresFeature;
import es.upv.dsic.issi.dplfw.dfm.RestrictionType;
import es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.VariableAttribute;
import es.upv.dsic.issi.dplfw.dfm.VariableType;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class DfmFactoryImpl extends EFactoryImpl implements DfmFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static DfmFactory init() {
		try {
			DfmFactory theDfmFactory = (DfmFactory)EPackage.Registry.INSTANCE.getEFactory(DfmPackage.eNS_URI);
			if (theDfmFactory != null) {
				return theDfmFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new DfmFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DfmFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case DfmPackage.DOCUMENT_FEATURE_MODEL: return createDocumentFeatureModel();
			case DfmPackage.CONTENT_DOCUMENT_FEATURE: return createContentDocumentFeature();
			case DfmPackage.TECHNOLOGY_DOCUMENT_FEATURE: return createTechnologyDocumentFeature();
			case DfmPackage.ANNOTATION: return createAnnotation();
			case DfmPackage.ANNOTATION_ENTRY: return createAnnotationEntry();
			case DfmPackage.REQUIRES_FEATURE: return createRequiresFeature();
			case DfmPackage.EXCLUDES_FEATURE: return createExcludesFeature();
			case DfmPackage.DOCUMENT_CONTEXT: return createDocumentContext();
			case DfmPackage.REFERENCE: return createReference();
			case DfmPackage.VARIABLE_ATTRIBUTE: return createVariableAttribute();
			case DfmPackage.CRITERION_ATTRIBUTE: return createCriterionAttribute();
			case DfmPackage.CRITERION: return createCriterion();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case DfmPackage.FEATURE_TYPE:
				return createFeatureTypeFromString(eDataType, initialValue);
			case DfmPackage.RESTRICTION_TYPE:
				return createRestrictionTypeFromString(eDataType, initialValue);
			case DfmPackage.VARIABLE_TYPE:
				return createVariableTypeFromString(eDataType, initialValue);
			case DfmPackage.METADATA_ELEMENT:
				return createMetadataElementFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case DfmPackage.FEATURE_TYPE:
				return convertFeatureTypeToString(eDataType, instanceValue);
			case DfmPackage.RESTRICTION_TYPE:
				return convertRestrictionTypeToString(eDataType, instanceValue);
			case DfmPackage.VARIABLE_TYPE:
				return convertVariableTypeToString(eDataType, instanceValue);
			case DfmPackage.METADATA_ELEMENT:
				return convertMetadataElementToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DocumentFeatureModel createDocumentFeatureModel() {
		DocumentFeatureModelImpl documentFeatureModel = new DocumentFeatureModelImpl();
		return documentFeatureModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ContentDocumentFeature createContentDocumentFeature() {
		ContentDocumentFeatureImpl contentDocumentFeature = new ContentDocumentFeatureImpl();
		return contentDocumentFeature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TechnologyDocumentFeature createTechnologyDocumentFeature() {
		TechnologyDocumentFeatureImpl technologyDocumentFeature = new TechnologyDocumentFeatureImpl();
		return technologyDocumentFeature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Annotation createAnnotation() {
		AnnotationImpl annotation = new AnnotationImpl();
		return annotation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AnnotationEntry createAnnotationEntry() {
		AnnotationEntryImpl annotationEntry = new AnnotationEntryImpl();
		return annotationEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RequiresFeature createRequiresFeature() {
		RequiresFeatureImpl requiresFeature = new RequiresFeatureImpl();
		return requiresFeature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ExcludesFeature createExcludesFeature() {
		ExcludesFeatureImpl excludesFeature = new ExcludesFeatureImpl();
		return excludesFeature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DocumentContext createDocumentContext() {
		DocumentContextImpl documentContext = new DocumentContextImpl();
		return documentContext;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Reference createReference() {
		ReferenceImpl reference = new ReferenceImpl();
		return reference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public VariableAttribute createVariableAttribute() {
		VariableAttributeImpl variableAttribute = new VariableAttributeImpl();
		return variableAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CriterionAttribute createCriterionAttribute() {
		CriterionAttributeImpl criterionAttribute = new CriterionAttributeImpl();
		return criterionAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Criterion createCriterion() {
		CriterionImpl criterion = new CriterionImpl();
		return criterion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FeatureType createFeatureTypeFromString(EDataType eDataType, String initialValue) {
		FeatureType result = FeatureType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertFeatureTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RestrictionType createRestrictionTypeFromString(EDataType eDataType, String initialValue) {
		RestrictionType result = RestrictionType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertRestrictionTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VariableType createVariableTypeFromString(EDataType eDataType, String initialValue) {
		VariableType result = VariableType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertVariableTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MetadataElement createMetadataElementFromString(EDataType eDataType, String initialValue) {
		MetadataElement result = MetadataElement.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertMetadataElementToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DfmPackage getDfmPackage() {
		return (DfmPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static DfmPackage getPackage() {
		return DfmPackage.eINSTANCE;
	}

} //DfmFactoryImpl
