/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfm.impl;

import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.UUID;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.CriterionAttribute;
import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.VariableAttribute;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Content Document Feature</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.ContentDocumentFeatureImpl#getInfoElementURI <em>Info Element URI</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.ContentDocumentFeatureImpl#getResponsible <em>Responsible</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.ContentDocumentFeatureImpl#getEditors <em>Editors</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.ContentDocumentFeatureImpl#getReaders <em>Readers</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.ContentDocumentFeatureImpl#getChildren <em>Children</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.ContentDocumentFeatureImpl#getProvidedBy <em>Provided By</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.ContentDocumentFeatureImpl#getSearchCriterion <em>Search Criterion</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfm.impl.ContentDocumentFeatureImpl#getVariableAttributes <em>Variable Attributes</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ContentDocumentFeatureImpl extends DocumentFeatureImpl implements ContentDocumentFeature {
	/**
	 * The default value of the '{@link #getInfoElementURI() <em>Info Element URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInfoElementURI()
	 * @generated
	 * @ordered
	 */
	protected static final URI INFO_ELEMENT_URI_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getInfoElementURI() <em>Info Element URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInfoElementURI()
	 * @generated
	 * @ordered
	 */
	protected URI infoElementURI = INFO_ELEMENT_URI_EDEFAULT;

	/**
	 * The default value of the '{@link #getResponsible() <em>Responsible</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResponsible()
	 * @generated
	 * @ordered
	 */
	protected static final UUID RESPONSIBLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getResponsible() <em>Responsible</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResponsible()
	 * @generated
	 * @ordered
	 */
	protected UUID responsible = RESPONSIBLE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getEditors() <em>Editors</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEditors()
	 * @generated
	 * @ordered
	 */
	protected EList<UUID> editors;

	/**
	 * The cached value of the '{@link #getReaders() <em>Readers</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReaders()
	 * @generated
	 * @ordered
	 */
	protected EList<UUID> readers;

	/**
	 * The cached value of the '{@link #getChildren() <em>Children</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChildren()
	 * @generated
	 * @ordered
	 */
	protected EList<ContentDocumentFeature> children;

	/**
	 * The cached value of the '{@link #getProvidedBy() <em>Provided By</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProvidedBy()
	 * @generated
	 * @ordered
	 */
	protected EList<TechnologyDocumentFeature> providedBy;

	/**
	 * The cached value of the '{@link #getSearchCriterion() <em>Search Criterion</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSearchCriterion()
	 * @generated
	 * @ordered
	 */
	protected CriterionAttribute searchCriterion;

	/**
	 * The cached value of the '{@link #getVariableAttributes() <em>Variable Attributes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVariableAttributes()
	 * @generated
	 * @ordered
	 */
	protected EList<VariableAttribute> variableAttributes;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ContentDocumentFeatureImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DfmPackage.Literals.CONTENT_DOCUMENT_FEATURE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ContentDocumentFeature> getChildren() {
		if (children == null) {
			children = new EObjectContainmentEList<ContentDocumentFeature>(ContentDocumentFeature.class, this, DfmPackage.CONTENT_DOCUMENT_FEATURE__CHILDREN);
		}
		return children;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<TechnologyDocumentFeature> getProvidedBy() {
		if (providedBy == null) {
			providedBy = new EObjectWithInverseResolvingEList.ManyInverse<TechnologyDocumentFeature>(TechnologyDocumentFeature.class, this, DfmPackage.CONTENT_DOCUMENT_FEATURE__PROVIDED_BY, DfmPackage.TECHNOLOGY_DOCUMENT_FEATURE__PROVIDES);
		}
		return providedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CriterionAttribute getSearchCriterion() {
		return searchCriterion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSearchCriterion(CriterionAttribute newSearchCriterion, NotificationChain msgs) {
		CriterionAttribute oldSearchCriterion = searchCriterion;
		searchCriterion = newSearchCriterion;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DfmPackage.CONTENT_DOCUMENT_FEATURE__SEARCH_CRITERION, oldSearchCriterion, newSearchCriterion);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSearchCriterion(CriterionAttribute newSearchCriterion) {
		if (newSearchCriterion != searchCriterion) {
			NotificationChain msgs = null;
			if (searchCriterion != null)
				msgs = ((InternalEObject)searchCriterion).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DfmPackage.CONTENT_DOCUMENT_FEATURE__SEARCH_CRITERION, null, msgs);
			if (newSearchCriterion != null)
				msgs = ((InternalEObject)newSearchCriterion).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DfmPackage.CONTENT_DOCUMENT_FEATURE__SEARCH_CRITERION, null, msgs);
			msgs = basicSetSearchCriterion(newSearchCriterion, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmPackage.CONTENT_DOCUMENT_FEATURE__SEARCH_CRITERION, newSearchCriterion, newSearchCriterion));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<VariableAttribute> getVariableAttributes() {
		if (variableAttributes == null) {
			variableAttributes = new EObjectContainmentEList<VariableAttribute>(VariableAttribute.class, this, DfmPackage.CONTENT_DOCUMENT_FEATURE__VARIABLE_ATTRIBUTES);
		}
		return variableAttributes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public void propagateEditors() {
		List<UUID> editors = getEditors();
		Stack<ContentDocumentFeature> pending = new Stack<ContentDocumentFeature>();
		pending.addAll(getChildren());
		while (!pending.empty()) {
			ContentDocumentFeature cdf = pending.pop();
			cdf.getEditors().clear();
			cdf.getEditors().addAll(editors);
			pending.addAll(cdf.getChildren());
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public void propagateReaders() {
		List<UUID> readers = getReaders();
		Stack<ContentDocumentFeature> pending = new Stack<ContentDocumentFeature>();
		pending.addAll(getChildren());
		while (!pending.empty()) {
			ContentDocumentFeature cdf = pending.pop();
			cdf.getReaders().clear();
			cdf.getReaders().addAll(readers);
			pending.addAll(cdf.getChildren());
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public void propagateResponsible() {
		UUID responsible = getResponsible();
		Stack<ContentDocumentFeature> pending = new Stack<ContentDocumentFeature>();
		pending.addAll(getChildren());
		while (!pending.empty()) {
			ContentDocumentFeature cdf = pending.pop();
			cdf.setResponsible(responsible);
			pending.addAll(cdf.getChildren());
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public void propagateAllPermissions() {
		propagateResponsible();
		propagateReaders();
		propagateEditors();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public URI getInfoElementURI() {
		return infoElementURI;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setInfoElementURI(URI newInfoElementURI) {
		URI oldInfoElementURI = infoElementURI;
		infoElementURI = newInfoElementURI;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmPackage.CONTENT_DOCUMENT_FEATURE__INFO_ELEMENT_URI, oldInfoElementURI, infoElementURI));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public UUID getResponsible() {
		return responsible;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setResponsible(UUID newResponsible) {
		UUID oldResponsible = responsible;
		responsible = newResponsible;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmPackage.CONTENT_DOCUMENT_FEATURE__RESPONSIBLE, oldResponsible, responsible));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<UUID> getEditors() {
		if (editors == null) {
			editors = new EDataTypeUniqueEList<UUID>(UUID.class, this, DfmPackage.CONTENT_DOCUMENT_FEATURE__EDITORS);
		}
		return editors;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<UUID> getReaders() {
		if (readers == null) {
			readers = new EDataTypeUniqueEList<UUID>(UUID.class, this, DfmPackage.CONTENT_DOCUMENT_FEATURE__READERS);
		}
		return readers;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__PROVIDED_BY:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getProvidedBy()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__CHILDREN:
				return ((InternalEList<?>)getChildren()).basicRemove(otherEnd, msgs);
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__PROVIDED_BY:
				return ((InternalEList<?>)getProvidedBy()).basicRemove(otherEnd, msgs);
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__SEARCH_CRITERION:
				return basicSetSearchCriterion(null, msgs);
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__VARIABLE_ATTRIBUTES:
				return ((InternalEList<?>)getVariableAttributes()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__INFO_ELEMENT_URI:
				return getInfoElementURI();
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__RESPONSIBLE:
				return getResponsible();
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__EDITORS:
				return getEditors();
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__READERS:
				return getReaders();
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__CHILDREN:
				return getChildren();
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__PROVIDED_BY:
				return getProvidedBy();
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__SEARCH_CRITERION:
				return getSearchCriterion();
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__VARIABLE_ATTRIBUTES:
				return getVariableAttributes();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__INFO_ELEMENT_URI:
				setInfoElementURI((URI)newValue);
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__RESPONSIBLE:
				setResponsible((UUID)newValue);
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__EDITORS:
				getEditors().clear();
				getEditors().addAll((Collection<? extends UUID>)newValue);
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__READERS:
				getReaders().clear();
				getReaders().addAll((Collection<? extends UUID>)newValue);
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__CHILDREN:
				getChildren().clear();
				getChildren().addAll((Collection<? extends ContentDocumentFeature>)newValue);
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__PROVIDED_BY:
				getProvidedBy().clear();
				getProvidedBy().addAll((Collection<? extends TechnologyDocumentFeature>)newValue);
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__SEARCH_CRITERION:
				setSearchCriterion((CriterionAttribute)newValue);
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__VARIABLE_ATTRIBUTES:
				getVariableAttributes().clear();
				getVariableAttributes().addAll((Collection<? extends VariableAttribute>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__INFO_ELEMENT_URI:
				setInfoElementURI(INFO_ELEMENT_URI_EDEFAULT);
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__RESPONSIBLE:
				setResponsible(RESPONSIBLE_EDEFAULT);
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__EDITORS:
				getEditors().clear();
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__READERS:
				getReaders().clear();
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__CHILDREN:
				getChildren().clear();
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__PROVIDED_BY:
				getProvidedBy().clear();
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__SEARCH_CRITERION:
				setSearchCriterion((CriterionAttribute)null);
				return;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__VARIABLE_ATTRIBUTES:
				getVariableAttributes().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__INFO_ELEMENT_URI:
				return INFO_ELEMENT_URI_EDEFAULT == null ? infoElementURI != null : !INFO_ELEMENT_URI_EDEFAULT.equals(infoElementURI);
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__RESPONSIBLE:
				return RESPONSIBLE_EDEFAULT == null ? responsible != null : !RESPONSIBLE_EDEFAULT.equals(responsible);
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__EDITORS:
				return editors != null && !editors.isEmpty();
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__READERS:
				return readers != null && !readers.isEmpty();
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__CHILDREN:
				return children != null && !children.isEmpty();
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__PROVIDED_BY:
				return providedBy != null && !providedBy.isEmpty();
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__SEARCH_CRITERION:
				return searchCriterion != null;
			case DfmPackage.CONTENT_DOCUMENT_FEATURE__VARIABLE_ATTRIBUTES:
				return variableAttributes != null && !variableAttributes.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (infoElementURI: ");
		result.append(infoElementURI);
		result.append(", responsible: ");
		result.append(responsible);
		result.append(", editors: ");
		result.append(editors);
		result.append(", readers: ");
		result.append(readers);
		result.append(')');
		return result.toString();
	}

} //ContentDocumentFeatureImpl
