/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfm;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see es.upv.dsic.issi.dplfw.dfm.DfmFactory
 * @model kind="package"
 * @generated
 */
public interface DfmPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "dfm";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://es.upv.dsic.issi/dplfw/dfm/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "dfm";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	DfmPackage eINSTANCE = es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl.init();

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureModelImpl <em>Document Feature Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureModelImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getDocumentFeatureModel()
	 * @generated
	 */
	int DOCUMENT_FEATURE_MODEL = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE_MODEL__NAME = 0;

	/**
	 * The feature id for the '<em><b>Features</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE_MODEL__FEATURES = 1;

	/**
	 * The feature id for the '<em><b>Contexts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE_MODEL__CONTEXTS = 2;

	/**
	 * The feature id for the '<em><b>Global Variable Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE_MODEL__GLOBAL_VARIABLE_ATTRIBUTE = 3;

	/**
	 * The number of structural features of the '<em>Document Feature Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE_MODEL_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureImpl <em>Document Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getDocumentFeature()
	 * @generated
	 */
	int DOCUMENT_FEATURE = 1;

	/**
	 * The feature id for the '<em><b>Visible Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE__VISIBLE_NAME = 0;

	/**
	 * The feature id for the '<em><b>Id Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE__ID_NAME = 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE__TYPE = 2;

	/**
	 * The feature id for the '<em><b>Requires</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE__REQUIRES = 3;

	/**
	 * The feature id for the '<em><b>Excludes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE__EXCLUDES = 4;

	/**
	 * The feature id for the '<em><b>Is Required By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE__IS_REQUIRED_BY = 5;

	/**
	 * The feature id for the '<em><b>Is Excluded By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE__IS_EXCLUDED_BY = 6;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE__ANNOTATIONS = 7;

	/**
	 * The feature id for the '<em><b>Document Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE__DOCUMENT_CONTEXT = 8;

	/**
	 * The number of structural features of the '<em>Document Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE_FEATURE_COUNT = 9;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.ContentDocumentFeatureImpl <em>Content Document Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.ContentDocumentFeatureImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getContentDocumentFeature()
	 * @generated
	 */
	int CONTENT_DOCUMENT_FEATURE = 2;

	/**
	 * The feature id for the '<em><b>Visible Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__VISIBLE_NAME = DOCUMENT_FEATURE__VISIBLE_NAME;

	/**
	 * The feature id for the '<em><b>Id Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__ID_NAME = DOCUMENT_FEATURE__ID_NAME;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__TYPE = DOCUMENT_FEATURE__TYPE;

	/**
	 * The feature id for the '<em><b>Requires</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__REQUIRES = DOCUMENT_FEATURE__REQUIRES;

	/**
	 * The feature id for the '<em><b>Excludes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__EXCLUDES = DOCUMENT_FEATURE__EXCLUDES;

	/**
	 * The feature id for the '<em><b>Is Required By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__IS_REQUIRED_BY = DOCUMENT_FEATURE__IS_REQUIRED_BY;

	/**
	 * The feature id for the '<em><b>Is Excluded By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__IS_EXCLUDED_BY = DOCUMENT_FEATURE__IS_EXCLUDED_BY;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__ANNOTATIONS = DOCUMENT_FEATURE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Document Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__DOCUMENT_CONTEXT = DOCUMENT_FEATURE__DOCUMENT_CONTEXT;

	/**
	 * The feature id for the '<em><b>Info Element URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__INFO_ELEMENT_URI = DOCUMENT_FEATURE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Responsible</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__RESPONSIBLE = DOCUMENT_FEATURE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Editors</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__EDITORS = DOCUMENT_FEATURE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Readers</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__READERS = DOCUMENT_FEATURE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__CHILDREN = DOCUMENT_FEATURE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Provided By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__PROVIDED_BY = DOCUMENT_FEATURE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Search Criterion</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__SEARCH_CRITERION = DOCUMENT_FEATURE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Variable Attributes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE__VARIABLE_ATTRIBUTES = DOCUMENT_FEATURE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Content Document Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_DOCUMENT_FEATURE_FEATURE_COUNT = DOCUMENT_FEATURE_FEATURE_COUNT + 8;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.TechnologyDocumentFeatureImpl <em>Technology Document Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.TechnologyDocumentFeatureImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getTechnologyDocumentFeature()
	 * @generated
	 */
	int TECHNOLOGY_DOCUMENT_FEATURE = 3;

	/**
	 * The feature id for the '<em><b>Visible Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TECHNOLOGY_DOCUMENT_FEATURE__VISIBLE_NAME = DOCUMENT_FEATURE__VISIBLE_NAME;

	/**
	 * The feature id for the '<em><b>Id Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TECHNOLOGY_DOCUMENT_FEATURE__ID_NAME = DOCUMENT_FEATURE__ID_NAME;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TECHNOLOGY_DOCUMENT_FEATURE__TYPE = DOCUMENT_FEATURE__TYPE;

	/**
	 * The feature id for the '<em><b>Requires</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TECHNOLOGY_DOCUMENT_FEATURE__REQUIRES = DOCUMENT_FEATURE__REQUIRES;

	/**
	 * The feature id for the '<em><b>Excludes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TECHNOLOGY_DOCUMENT_FEATURE__EXCLUDES = DOCUMENT_FEATURE__EXCLUDES;

	/**
	 * The feature id for the '<em><b>Is Required By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TECHNOLOGY_DOCUMENT_FEATURE__IS_REQUIRED_BY = DOCUMENT_FEATURE__IS_REQUIRED_BY;

	/**
	 * The feature id for the '<em><b>Is Excluded By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TECHNOLOGY_DOCUMENT_FEATURE__IS_EXCLUDED_BY = DOCUMENT_FEATURE__IS_EXCLUDED_BY;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TECHNOLOGY_DOCUMENT_FEATURE__ANNOTATIONS = DOCUMENT_FEATURE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Document Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TECHNOLOGY_DOCUMENT_FEATURE__DOCUMENT_CONTEXT = DOCUMENT_FEATURE__DOCUMENT_CONTEXT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TECHNOLOGY_DOCUMENT_FEATURE__CHILDREN = DOCUMENT_FEATURE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Provides</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TECHNOLOGY_DOCUMENT_FEATURE__PROVIDES = DOCUMENT_FEATURE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Technology Document Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TECHNOLOGY_DOCUMENT_FEATURE_FEATURE_COUNT = DOCUMENT_FEATURE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.AnnotationImpl <em>Annotation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.AnnotationImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getAnnotation()
	 * @generated
	 */
	int ANNOTATION = 4;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__ENTRIES = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__NAME = 1;

	/**
	 * The number of structural features of the '<em>Annotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.AnnotationEntryImpl <em>Annotation Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.AnnotationEntryImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getAnnotationEntry()
	 * @generated
	 */
	int ANNOTATION_ENTRY = 5;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_ENTRY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_ENTRY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Annotation Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_ENTRY_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.RequiresFeatureImpl <em>Requires Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.RequiresFeatureImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getRequiresFeature()
	 * @generated
	 */
	int REQUIRES_FEATURE = 6;

	/**
	 * The feature id for the '<em><b>Candidates</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIRES_FEATURE__CANDIDATES = 0;

	/**
	 * The feature id for the '<em><b>Owner Feature</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIRES_FEATURE__OWNER_FEATURE = 1;

	/**
	 * The number of structural features of the '<em>Requires Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIRES_FEATURE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.ExcludesFeatureImpl <em>Excludes Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.ExcludesFeatureImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getExcludesFeature()
	 * @generated
	 */
	int EXCLUDES_FEATURE = 7;

	/**
	 * The feature id for the '<em><b>Candidates</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCLUDES_FEATURE__CANDIDATES = 0;

	/**
	 * The feature id for the '<em><b>Owner Feature</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCLUDES_FEATURE__OWNER_FEATURE = 1;

	/**
	 * The number of structural features of the '<em>Excludes Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCLUDES_FEATURE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentContextImpl <em>Document Context</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DocumentContextImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getDocumentContext()
	 * @generated
	 */
	int DOCUMENT_CONTEXT = 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_CONTEXT__NAME = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_CONTEXT__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Candidates</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_CONTEXT__CANDIDATES = 2;

	/**
	 * The number of structural features of the '<em>Document Context</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_CONTEXT_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.AttributeImpl <em>Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.AttributeImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getAttribute()
	 * @generated
	 */
	int ATTRIBUTE = 9;

	/**
	 * The feature id for the '<em><b>Id Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__ID_NAME = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__DESCRIPTION = 1;

	/**
	 * The number of structural features of the '<em>Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.ReferenceImpl <em>Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.ReferenceImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getReference()
	 * @generated
	 */
	int REFERENCE = 10;

	/**
	 * The feature id for the '<em><b>Info Element URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__INFO_ELEMENT_URI = 0;

	/**
	 * The feature id for the '<em><b>Reference Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__REFERENCE_NAME = 1;

	/**
	 * The number of structural features of the '<em>Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.VariableAttributeImpl <em>Variable Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.VariableAttributeImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getVariableAttribute()
	 * @generated
	 */
	int VARIABLE_ATTRIBUTE = 11;

	/**
	 * The feature id for the '<em><b>Id Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ATTRIBUTE__ID_NAME = ATTRIBUTE__ID_NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ATTRIBUTE__DESCRIPTION = ATTRIBUTE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ATTRIBUTE__REFERENCES = ATTRIBUTE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ATTRIBUTE__TYPE = ATTRIBUTE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Variable Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ATTRIBUTE_FEATURE_COUNT = ATTRIBUTE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.CriterionAttributeImpl <em>Criterion Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.CriterionAttributeImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getCriterionAttribute()
	 * @generated
	 */
	int CRITERION_ATTRIBUTE = 12;

	/**
	 * The feature id for the '<em><b>Id Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRITERION_ATTRIBUTE__ID_NAME = ATTRIBUTE__ID_NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRITERION_ATTRIBUTE__DESCRIPTION = ATTRIBUTE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Criteria</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRITERION_ATTRIBUTE__CRITERIA = ATTRIBUTE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Criterion Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRITERION_ATTRIBUTE_FEATURE_COUNT = ATTRIBUTE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.CriterionImpl <em>Criterion</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.CriterionImpl
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getCriterion()
	 * @generated
	 */
	int CRITERION = 13;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRITERION__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Metadata Element</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRITERION__METADATA_ELEMENT = 1;

	/**
	 * The number of structural features of the '<em>Criterion</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRITERION_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.FeatureType <em>Feature Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.FeatureType
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getFeatureType()
	 * @generated
	 */
	int FEATURE_TYPE = 14;


	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.RestrictionType <em>Restriction Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.RestrictionType
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getRestrictionType()
	 * @generated
	 */
	int RESTRICTION_TYPE = 15;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.VariableType <em>Variable Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.VariableType
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getVariableType()
	 * @generated
	 */
	int VARIABLE_TYPE = 16;

	/**
	 * The meta object id for the '{@link es.upv.dsic.issi.dplfw.dfm.MetadataElement <em>Metadata Element</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see es.upv.dsic.issi.dplfw.dfm.MetadataElement
	 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getMetadataElement()
	 * @generated
	 */
	int METADATA_ELEMENT = 17;

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel <em>Document Feature Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Document Feature Model</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel
	 * @generated
	 */
	EClass getDocumentFeatureModel();

	/**
	 * Returns the meta object for the containment reference list '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel#getFeatures <em>Features</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Features</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel#getFeatures()
	 * @see #getDocumentFeatureModel()
	 * @generated
	 */
	EReference getDocumentFeatureModel_Features();

	/**
	 * Returns the meta object for the containment reference list '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel#getContexts <em>Contexts</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Contexts</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel#getContexts()
	 * @see #getDocumentFeatureModel()
	 * @generated
	 */
	EReference getDocumentFeatureModel_Contexts();

	/**
	 * Returns the meta object for the containment reference list '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel#getGlobalVariableAttribute <em>Global Variable Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Global Variable Attribute</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel#getGlobalVariableAttribute()
	 * @see #getDocumentFeatureModel()
	 * @generated
	 */
	EReference getDocumentFeatureModel_GlobalVariableAttribute();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel#getName()
	 * @see #getDocumentFeatureModel()
	 * @generated
	 */
	EAttribute getDocumentFeatureModel_Name();

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeature <em>Document Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Document Feature</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeature
	 * @generated
	 */
	EClass getDocumentFeature();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getIdName <em>Id Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id Name</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getIdName()
	 * @see #getDocumentFeature()
	 * @generated
	 */
	EAttribute getDocumentFeature_IdName();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getType()
	 * @see #getDocumentFeature()
	 * @generated
	 */
	EAttribute getDocumentFeature_Type();

	/**
	 * Returns the meta object for the containment reference list '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getRequires <em>Requires</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Requires</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getRequires()
	 * @see #getDocumentFeature()
	 * @generated
	 */
	EReference getDocumentFeature_Requires();

	/**
	 * Returns the meta object for the containment reference list '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getExcludes <em>Excludes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Excludes</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getExcludes()
	 * @see #getDocumentFeature()
	 * @generated
	 */
	EReference getDocumentFeature_Excludes();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getVisibleName <em>Visible Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Visible Name</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getVisibleName()
	 * @see #getDocumentFeature()
	 * @generated
	 */
	EAttribute getDocumentFeature_VisibleName();

	/**
	 * Returns the meta object for the reference list '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getIsRequiredBy <em>Is Required By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Is Required By</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getIsRequiredBy()
	 * @see #getDocumentFeature()
	 * @generated
	 */
	EReference getDocumentFeature_IsRequiredBy();

	/**
	 * Returns the meta object for the reference list '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getIsExcludedBy <em>Is Excluded By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Is Excluded By</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getIsExcludedBy()
	 * @see #getDocumentFeature()
	 * @generated
	 */
	EReference getDocumentFeature_IsExcludedBy();

	/**
	 * Returns the meta object for the containment reference list '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getAnnotations <em>Annotations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Annotations</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getAnnotations()
	 * @see #getDocumentFeature()
	 * @generated
	 */
	EReference getDocumentFeature_Annotations();

	/**
	 * Returns the meta object for the reference list '{@link es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getDocumentContext <em>Document Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Document Context</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentFeature#getDocumentContext()
	 * @see #getDocumentFeature()
	 * @generated
	 */
	EReference getDocumentFeature_DocumentContext();

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature <em>Content Document Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Content Document Feature</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature
	 * @generated
	 */
	EClass getContentDocumentFeature();

	/**
	 * Returns the meta object for the containment reference list '{@link es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getChildren <em>Children</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Children</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getChildren()
	 * @see #getContentDocumentFeature()
	 * @generated
	 */
	EReference getContentDocumentFeature_Children();

	/**
	 * Returns the meta object for the reference list '{@link es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getProvidedBy <em>Provided By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Provided By</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getProvidedBy()
	 * @see #getContentDocumentFeature()
	 * @generated
	 */
	EReference getContentDocumentFeature_ProvidedBy();

	/**
	 * Returns the meta object for the containment reference '{@link es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getSearchCriterion <em>Search Criterion</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Search Criterion</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getSearchCriterion()
	 * @see #getContentDocumentFeature()
	 * @generated
	 */
	EReference getContentDocumentFeature_SearchCriterion();

	/**
	 * Returns the meta object for the containment reference list '{@link es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getVariableAttributes <em>Variable Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Variable Attributes</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getVariableAttributes()
	 * @see #getContentDocumentFeature()
	 * @generated
	 */
	EReference getContentDocumentFeature_VariableAttributes();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getInfoElementURI <em>Info Element URI</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Info Element URI</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getInfoElementURI()
	 * @see #getContentDocumentFeature()
	 * @generated
	 */
	EAttribute getContentDocumentFeature_InfoElementURI();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getResponsible <em>Responsible</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Responsible</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getResponsible()
	 * @see #getContentDocumentFeature()
	 * @generated
	 */
	EAttribute getContentDocumentFeature_Responsible();

	/**
	 * Returns the meta object for the attribute list '{@link es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getEditors <em>Editors</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Editors</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getEditors()
	 * @see #getContentDocumentFeature()
	 * @generated
	 */
	EAttribute getContentDocumentFeature_Editors();

	/**
	 * Returns the meta object for the attribute list '{@link es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getReaders <em>Readers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Readers</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature#getReaders()
	 * @see #getContentDocumentFeature()
	 * @generated
	 */
	EAttribute getContentDocumentFeature_Readers();

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature <em>Technology Document Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Technology Document Feature</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature
	 * @generated
	 */
	EClass getTechnologyDocumentFeature();

	/**
	 * Returns the meta object for the containment reference list '{@link es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature#getChildren <em>Children</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Children</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature#getChildren()
	 * @see #getTechnologyDocumentFeature()
	 * @generated
	 */
	EReference getTechnologyDocumentFeature_Children();

	/**
	 * Returns the meta object for the reference list '{@link es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature#getProvides <em>Provides</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Provides</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature#getProvides()
	 * @see #getTechnologyDocumentFeature()
	 * @generated
	 */
	EReference getTechnologyDocumentFeature_Provides();

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.Annotation <em>Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Annotation</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.Annotation
	 * @generated
	 */
	EClass getAnnotation();

	/**
	 * Returns the meta object for the containment reference list '{@link es.upv.dsic.issi.dplfw.dfm.Annotation#getEntries <em>Entries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Entries</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.Annotation#getEntries()
	 * @see #getAnnotation()
	 * @generated
	 */
	EReference getAnnotation_Entries();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.Annotation#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.Annotation#getName()
	 * @see #getAnnotation()
	 * @generated
	 */
	EAttribute getAnnotation_Name();

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.AnnotationEntry <em>Annotation Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Annotation Entry</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.AnnotationEntry
	 * @generated
	 */
	EClass getAnnotationEntry();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.AnnotationEntry#getKey <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.AnnotationEntry#getKey()
	 * @see #getAnnotationEntry()
	 * @generated
	 */
	EAttribute getAnnotationEntry_Key();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.AnnotationEntry#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.AnnotationEntry#getValue()
	 * @see #getAnnotationEntry()
	 * @generated
	 */
	EAttribute getAnnotationEntry_Value();

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.RequiresFeature <em>Requires Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Requires Feature</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.RequiresFeature
	 * @generated
	 */
	EClass getRequiresFeature();

	/**
	 * Returns the meta object for the reference list '{@link es.upv.dsic.issi.dplfw.dfm.RequiresFeature#getCandidates <em>Candidates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Candidates</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.RequiresFeature#getCandidates()
	 * @see #getRequiresFeature()
	 * @generated
	 */
	EReference getRequiresFeature_Candidates();

	/**
	 * Returns the meta object for the container reference '{@link es.upv.dsic.issi.dplfw.dfm.RequiresFeature#getOwnerFeature <em>Owner Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner Feature</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.RequiresFeature#getOwnerFeature()
	 * @see #getRequiresFeature()
	 * @generated
	 */
	EReference getRequiresFeature_OwnerFeature();

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.ExcludesFeature <em>Excludes Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Excludes Feature</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.ExcludesFeature
	 * @generated
	 */
	EClass getExcludesFeature();

	/**
	 * Returns the meta object for the reference list '{@link es.upv.dsic.issi.dplfw.dfm.ExcludesFeature#getCandidates <em>Candidates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Candidates</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.ExcludesFeature#getCandidates()
	 * @see #getExcludesFeature()
	 * @generated
	 */
	EReference getExcludesFeature_Candidates();

	/**
	 * Returns the meta object for the container reference '{@link es.upv.dsic.issi.dplfw.dfm.ExcludesFeature#getOwnerFeature <em>Owner Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owner Feature</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.ExcludesFeature#getOwnerFeature()
	 * @see #getExcludesFeature()
	 * @generated
	 */
	EReference getExcludesFeature_OwnerFeature();

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.DocumentContext <em>Document Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Document Context</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentContext
	 * @generated
	 */
	EClass getDocumentContext();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.DocumentContext#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentContext#getName()
	 * @see #getDocumentContext()
	 * @generated
	 */
	EAttribute getDocumentContext_Name();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.DocumentContext#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentContext#getDescription()
	 * @see #getDocumentContext()
	 * @generated
	 */
	EAttribute getDocumentContext_Description();

	/**
	 * Returns the meta object for the reference list '{@link es.upv.dsic.issi.dplfw.dfm.DocumentContext#getCandidates <em>Candidates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Candidates</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.DocumentContext#getCandidates()
	 * @see #getDocumentContext()
	 * @generated
	 */
	EReference getDocumentContext_Candidates();

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.Attribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.Attribute
	 * @generated
	 */
	EClass getAttribute();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.Attribute#getIdName <em>Id Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id Name</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.Attribute#getIdName()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_IdName();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.Attribute#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.Attribute#getDescription()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Description();

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.Reference <em>Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reference</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.Reference
	 * @generated
	 */
	EClass getReference();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.Reference#getInfoElementURI <em>Info Element URI</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Info Element URI</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.Reference#getInfoElementURI()
	 * @see #getReference()
	 * @generated
	 */
	EAttribute getReference_InfoElementURI();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.Reference#getReferenceName <em>Reference Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reference Name</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.Reference#getReferenceName()
	 * @see #getReference()
	 * @generated
	 */
	EAttribute getReference_ReferenceName();

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.VariableAttribute <em>Variable Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Variable Attribute</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.VariableAttribute
	 * @generated
	 */
	EClass getVariableAttribute();

	/**
	 * Returns the meta object for the containment reference list '{@link es.upv.dsic.issi.dplfw.dfm.VariableAttribute#getReferences <em>References</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>References</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.VariableAttribute#getReferences()
	 * @see #getVariableAttribute()
	 * @generated
	 */
	EReference getVariableAttribute_References();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.VariableAttribute#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.VariableAttribute#getType()
	 * @see #getVariableAttribute()
	 * @generated
	 */
	EAttribute getVariableAttribute_Type();

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.CriterionAttribute <em>Criterion Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Criterion Attribute</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.CriterionAttribute
	 * @generated
	 */
	EClass getCriterionAttribute();

	/**
	 * Returns the meta object for the containment reference list '{@link es.upv.dsic.issi.dplfw.dfm.CriterionAttribute#getCriteria <em>Criteria</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Criteria</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.CriterionAttribute#getCriteria()
	 * @see #getCriterionAttribute()
	 * @generated
	 */
	EReference getCriterionAttribute_Criteria();

	/**
	 * Returns the meta object for class '{@link es.upv.dsic.issi.dplfw.dfm.Criterion <em>Criterion</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Criterion</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.Criterion
	 * @generated
	 */
	EClass getCriterion();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.Criterion#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.Criterion#getValue()
	 * @see #getCriterion()
	 * @generated
	 */
	EAttribute getCriterion_Value();

	/**
	 * Returns the meta object for the attribute '{@link es.upv.dsic.issi.dplfw.dfm.Criterion#getMetadataElement <em>Metadata Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Metadata Element</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.Criterion#getMetadataElement()
	 * @see #getCriterion()
	 * @generated
	 */
	EAttribute getCriterion_MetadataElement();

	/**
	 * Returns the meta object for enum '{@link es.upv.dsic.issi.dplfw.dfm.FeatureType <em>Feature Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Feature Type</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.FeatureType
	 * @generated
	 */
	EEnum getFeatureType();

	/**
	 * Returns the meta object for enum '{@link es.upv.dsic.issi.dplfw.dfm.RestrictionType <em>Restriction Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Restriction Type</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.RestrictionType
	 * @generated
	 */
	EEnum getRestrictionType();

	/**
	 * Returns the meta object for enum '{@link es.upv.dsic.issi.dplfw.dfm.VariableType <em>Variable Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Variable Type</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.VariableType
	 * @generated
	 */
	EEnum getVariableType();

	/**
	 * Returns the meta object for enum '{@link es.upv.dsic.issi.dplfw.dfm.MetadataElement <em>Metadata Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Metadata Element</em>'.
	 * @see es.upv.dsic.issi.dplfw.dfm.MetadataElement
	 * @generated
	 */
	EEnum getMetadataElement();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	DfmFactory getDfmFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureModelImpl <em>Document Feature Model</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureModelImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getDocumentFeatureModel()
		 * @generated
		 */
		EClass DOCUMENT_FEATURE_MODEL = eINSTANCE.getDocumentFeatureModel();

		/**
		 * The meta object literal for the '<em><b>Features</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_FEATURE_MODEL__FEATURES = eINSTANCE.getDocumentFeatureModel_Features();

		/**
		 * The meta object literal for the '<em><b>Contexts</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_FEATURE_MODEL__CONTEXTS = eINSTANCE.getDocumentFeatureModel_Contexts();

		/**
		 * The meta object literal for the '<em><b>Global Variable Attribute</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_FEATURE_MODEL__GLOBAL_VARIABLE_ATTRIBUTE = eINSTANCE.getDocumentFeatureModel_GlobalVariableAttribute();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENT_FEATURE_MODEL__NAME = eINSTANCE.getDocumentFeatureModel_Name();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureImpl <em>Document Feature</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DocumentFeatureImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getDocumentFeature()
		 * @generated
		 */
		EClass DOCUMENT_FEATURE = eINSTANCE.getDocumentFeature();

		/**
		 * The meta object literal for the '<em><b>Id Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENT_FEATURE__ID_NAME = eINSTANCE.getDocumentFeature_IdName();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENT_FEATURE__TYPE = eINSTANCE.getDocumentFeature_Type();

		/**
		 * The meta object literal for the '<em><b>Requires</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_FEATURE__REQUIRES = eINSTANCE.getDocumentFeature_Requires();

		/**
		 * The meta object literal for the '<em><b>Excludes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_FEATURE__EXCLUDES = eINSTANCE.getDocumentFeature_Excludes();

		/**
		 * The meta object literal for the '<em><b>Visible Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENT_FEATURE__VISIBLE_NAME = eINSTANCE.getDocumentFeature_VisibleName();

		/**
		 * The meta object literal for the '<em><b>Is Required By</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_FEATURE__IS_REQUIRED_BY = eINSTANCE.getDocumentFeature_IsRequiredBy();

		/**
		 * The meta object literal for the '<em><b>Is Excluded By</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_FEATURE__IS_EXCLUDED_BY = eINSTANCE.getDocumentFeature_IsExcludedBy();

		/**
		 * The meta object literal for the '<em><b>Annotations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_FEATURE__ANNOTATIONS = eINSTANCE.getDocumentFeature_Annotations();

		/**
		 * The meta object literal for the '<em><b>Document Context</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_FEATURE__DOCUMENT_CONTEXT = eINSTANCE.getDocumentFeature_DocumentContext();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.ContentDocumentFeatureImpl <em>Content Document Feature</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.ContentDocumentFeatureImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getContentDocumentFeature()
		 * @generated
		 */
		EClass CONTENT_DOCUMENT_FEATURE = eINSTANCE.getContentDocumentFeature();

		/**
		 * The meta object literal for the '<em><b>Children</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTENT_DOCUMENT_FEATURE__CHILDREN = eINSTANCE.getContentDocumentFeature_Children();

		/**
		 * The meta object literal for the '<em><b>Provided By</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTENT_DOCUMENT_FEATURE__PROVIDED_BY = eINSTANCE.getContentDocumentFeature_ProvidedBy();

		/**
		 * The meta object literal for the '<em><b>Search Criterion</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTENT_DOCUMENT_FEATURE__SEARCH_CRITERION = eINSTANCE.getContentDocumentFeature_SearchCriterion();

		/**
		 * The meta object literal for the '<em><b>Variable Attributes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTENT_DOCUMENT_FEATURE__VARIABLE_ATTRIBUTES = eINSTANCE.getContentDocumentFeature_VariableAttributes();

		/**
		 * The meta object literal for the '<em><b>Info Element URI</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTENT_DOCUMENT_FEATURE__INFO_ELEMENT_URI = eINSTANCE.getContentDocumentFeature_InfoElementURI();

		/**
		 * The meta object literal for the '<em><b>Responsible</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTENT_DOCUMENT_FEATURE__RESPONSIBLE = eINSTANCE.getContentDocumentFeature_Responsible();

		/**
		 * The meta object literal for the '<em><b>Editors</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTENT_DOCUMENT_FEATURE__EDITORS = eINSTANCE.getContentDocumentFeature_Editors();

		/**
		 * The meta object literal for the '<em><b>Readers</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTENT_DOCUMENT_FEATURE__READERS = eINSTANCE.getContentDocumentFeature_Readers();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.TechnologyDocumentFeatureImpl <em>Technology Document Feature</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.TechnologyDocumentFeatureImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getTechnologyDocumentFeature()
		 * @generated
		 */
		EClass TECHNOLOGY_DOCUMENT_FEATURE = eINSTANCE.getTechnologyDocumentFeature();

		/**
		 * The meta object literal for the '<em><b>Children</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TECHNOLOGY_DOCUMENT_FEATURE__CHILDREN = eINSTANCE.getTechnologyDocumentFeature_Children();

		/**
		 * The meta object literal for the '<em><b>Provides</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TECHNOLOGY_DOCUMENT_FEATURE__PROVIDES = eINSTANCE.getTechnologyDocumentFeature_Provides();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.AnnotationImpl <em>Annotation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.AnnotationImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getAnnotation()
		 * @generated
		 */
		EClass ANNOTATION = eINSTANCE.getAnnotation();

		/**
		 * The meta object literal for the '<em><b>Entries</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION__ENTRIES = eINSTANCE.getAnnotation_Entries();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ANNOTATION__NAME = eINSTANCE.getAnnotation_Name();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.AnnotationEntryImpl <em>Annotation Entry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.AnnotationEntryImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getAnnotationEntry()
		 * @generated
		 */
		EClass ANNOTATION_ENTRY = eINSTANCE.getAnnotationEntry();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ANNOTATION_ENTRY__KEY = eINSTANCE.getAnnotationEntry_Key();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ANNOTATION_ENTRY__VALUE = eINSTANCE.getAnnotationEntry_Value();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.RequiresFeatureImpl <em>Requires Feature</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.RequiresFeatureImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getRequiresFeature()
		 * @generated
		 */
		EClass REQUIRES_FEATURE = eINSTANCE.getRequiresFeature();

		/**
		 * The meta object literal for the '<em><b>Candidates</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REQUIRES_FEATURE__CANDIDATES = eINSTANCE.getRequiresFeature_Candidates();

		/**
		 * The meta object literal for the '<em><b>Owner Feature</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REQUIRES_FEATURE__OWNER_FEATURE = eINSTANCE.getRequiresFeature_OwnerFeature();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.ExcludesFeatureImpl <em>Excludes Feature</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.ExcludesFeatureImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getExcludesFeature()
		 * @generated
		 */
		EClass EXCLUDES_FEATURE = eINSTANCE.getExcludesFeature();

		/**
		 * The meta object literal for the '<em><b>Candidates</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXCLUDES_FEATURE__CANDIDATES = eINSTANCE.getExcludesFeature_Candidates();

		/**
		 * The meta object literal for the '<em><b>Owner Feature</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXCLUDES_FEATURE__OWNER_FEATURE = eINSTANCE.getExcludesFeature_OwnerFeature();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.DocumentContextImpl <em>Document Context</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DocumentContextImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getDocumentContext()
		 * @generated
		 */
		EClass DOCUMENT_CONTEXT = eINSTANCE.getDocumentContext();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENT_CONTEXT__NAME = eINSTANCE.getDocumentContext_Name();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENT_CONTEXT__DESCRIPTION = eINSTANCE.getDocumentContext_Description();

		/**
		 * The meta object literal for the '<em><b>Candidates</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_CONTEXT__CANDIDATES = eINSTANCE.getDocumentContext_Candidates();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.AttributeImpl <em>Attribute</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.AttributeImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getAttribute()
		 * @generated
		 */
		EClass ATTRIBUTE = eINSTANCE.getAttribute();

		/**
		 * The meta object literal for the '<em><b>Id Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__ID_NAME = eINSTANCE.getAttribute_IdName();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__DESCRIPTION = eINSTANCE.getAttribute_Description();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.ReferenceImpl <em>Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.ReferenceImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getReference()
		 * @generated
		 */
		EClass REFERENCE = eINSTANCE.getReference();

		/**
		 * The meta object literal for the '<em><b>Info Element URI</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REFERENCE__INFO_ELEMENT_URI = eINSTANCE.getReference_InfoElementURI();

		/**
		 * The meta object literal for the '<em><b>Reference Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REFERENCE__REFERENCE_NAME = eINSTANCE.getReference_ReferenceName();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.VariableAttributeImpl <em>Variable Attribute</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.VariableAttributeImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getVariableAttribute()
		 * @generated
		 */
		EClass VARIABLE_ATTRIBUTE = eINSTANCE.getVariableAttribute();

		/**
		 * The meta object literal for the '<em><b>References</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIABLE_ATTRIBUTE__REFERENCES = eINSTANCE.getVariableAttribute_References();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VARIABLE_ATTRIBUTE__TYPE = eINSTANCE.getVariableAttribute_Type();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.CriterionAttributeImpl <em>Criterion Attribute</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.CriterionAttributeImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getCriterionAttribute()
		 * @generated
		 */
		EClass CRITERION_ATTRIBUTE = eINSTANCE.getCriterionAttribute();

		/**
		 * The meta object literal for the '<em><b>Criteria</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CRITERION_ATTRIBUTE__CRITERIA = eINSTANCE.getCriterionAttribute_Criteria();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.impl.CriterionImpl <em>Criterion</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.CriterionImpl
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getCriterion()
		 * @generated
		 */
		EClass CRITERION = eINSTANCE.getCriterion();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CRITERION__VALUE = eINSTANCE.getCriterion_Value();

		/**
		 * The meta object literal for the '<em><b>Metadata Element</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CRITERION__METADATA_ELEMENT = eINSTANCE.getCriterion_MetadataElement();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.FeatureType <em>Feature Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.FeatureType
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getFeatureType()
		 * @generated
		 */
		EEnum FEATURE_TYPE = eINSTANCE.getFeatureType();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.RestrictionType <em>Restriction Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.RestrictionType
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getRestrictionType()
		 * @generated
		 */
		EEnum RESTRICTION_TYPE = eINSTANCE.getRestrictionType();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.VariableType <em>Variable Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.VariableType
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getVariableType()
		 * @generated
		 */
		EEnum VARIABLE_TYPE = eINSTANCE.getVariableType();

		/**
		 * The meta object literal for the '{@link es.upv.dsic.issi.dplfw.dfm.MetadataElement <em>Metadata Element</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see es.upv.dsic.issi.dplfw.dfm.MetadataElement
		 * @see es.upv.dsic.issi.dplfw.dfm.impl.DfmPackageImpl#getMetadataElement()
		 * @generated
		 */
		EEnum METADATA_ELEMENT = eINSTANCE.getMetadataElement();

	}

} //DfmPackage
