/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm.fama.validation;

import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.ExcludesFeature;
import es.upv.dsic.issi.dplfw.dfm.RequiresFeature;
import es.upv.dsic.issi.dplfw.dfm.fama.transformer.DfmToFamaTransformer;
import es.upv.dsic.issi.dplfw.fama.FamaDplfwBridePlugin;
import es.us.isa.FAMA.Reasoner.Question;
import es.us.isa.FAMA.Reasoner.QuestionTrader;
import es.us.isa.FAMA.Reasoner.questions.DetectErrorsQuestion;
import es.us.isa.FAMA.Reasoner.questions.ExplainErrorsQuestion;
import es.us.isa.FAMA.errors.Error;
import es.us.isa.FAMA.errors.Explanation;
import es.us.isa.FAMA.models.featureModel.GenericRelation;
import es.us.isa.FAMA.models.variabilityModel.VariabilityModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;

public class FamaBatchConstraints
extends AbstractModelConstraint {
    private Resource resource;

    public IStatus validate(IValidationContext context) {
        ArrayList<Object> statuses = new ArrayList<Object>();
        EObject eObject = context.getTarget();
        this.resource = eObject.eResource();
        EMFEventType eType = context.getEventType();
        if (eType == EMFEventType.NULL) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)this.resource.getContents().get(0));
            if (eObject instanceof DocumentFeatureModel && diagnostic.getSeverity() == 0) {
                DocumentFeatureModel dfm = (DocumentFeatureModel)eObject;
                VariabilityModel vm = new DfmToFamaTransformer(dfm).convert();
                QuestionTrader qt = FamaDplfwBridePlugin.getDefault().getQuestionTrader();
                qt.setVariabilityModel(vm);
                qt.setSelectedReasoner("ChocoAtt");
                DetectErrorsQuestion detectErrQuest = (DetectErrorsQuestion)qt.createQuestion("DetectErrors");
                detectErrQuest.setObservations(vm.getObservations());
                qt.ask((Question)detectErrQuest);
                Collection errors = detectErrQuest.getErrors();
                if (!errors.isEmpty()) {
                    qt.setSelectedReasoner("ChocoAtt4Exp");
                    ExplainErrorsQuestion explainErrQuest = (ExplainErrorsQuestion)qt.createQuestion("Explanations");
                    explainErrQuest.setErrors(errors);
                    qt.ask((Question)explainErrQuest);
                    errors = explainErrQuest.getErrors();
                    for (Error error : errors) {
                        ArrayList<ConstraintStatus> childStatuses = new ArrayList<ConstraintStatus>();
                        Collection explanations = error.getExplanations();
                        ConstraintStatus errorStatus = ConstraintStatus.createStatus((IValidationContext)context, (EObject)this.getTarget(error.toString()), null, (int)4, (int)1, (String)error.toString(), (Object[])new Object[0]);
                        statuses.add(errorStatus);
                        HashSet<GenericRelation> relations = new HashSet<GenericRelation>();
                        for (Explanation explanation : explanations) {
                            GenericRelation firstRelation = (GenericRelation)explanation.getRelations().iterator().next();
                            if (relations.contains(firstRelation)) continue;
                            relations.add(firstRelation);
                            childStatuses.add(ConstraintStatus.createStatus((IValidationContext)context, (EObject)this.getTarget(explanation.toString()), null, (int)1, (int)1, (String)this.buildExplanationText(explanation), (Object[])new Object[0]));
                        }
                        if (childStatuses.isEmpty()) continue;
                        MultiStatus multiStatus = (MultiStatus)ConstraintStatus.createMultiStatus((IValidationContext)context, (String)String.format("Explanations for \"%s\"", error.toString()), null, childStatuses);
                        statuses.add(multiStatus);
                    }
                }
            } else {
                statuses.add(ConstraintStatus.createStatus((IValidationContext)context, null, (String)"Unable to analyse syntactically invalid feature model", (Object[])new Object[0]));
            }
        }
        if (!statuses.isEmpty()) {
            return ConstraintStatus.createMultiStatus((IValidationContext)context, statuses);
        }
        return context.createSuccessStatus();
    }

    private String buildExplanationText(Explanation explanation) {
        EObject target = this.getTarget(explanation.toString());
        String explanationText = explanation.toString();
        if (target != null) {
            if (explanationText.startsWith("MAN: ")) {
                return String.format("Feature %s is mandatory", ((DocumentFeature)target).getIdName());
            }
            if (explanationText.startsWith("EXC: ")) {
                return String.format("Feature %s excludes (%s)", ((ExcludesFeature)target).getOwnerFeature().getIdName(), this.buildOrText((List<DocumentFeature>)((ExcludesFeature)target).getCandidates()));
            }
            if (explanationText.startsWith("REQ: ")) {
                return String.format("Feature %s requires (%s)", ((RequiresFeature)target).getOwnerFeature().getIdName(), this.buildOrText((List<DocumentFeature>)((RequiresFeature)target).getCandidates()));
            }
        }
        return explanation.toString();
    }

    private String buildOrText(List<DocumentFeature> features) {
        StringBuilder builder = new StringBuilder();
        for (DocumentFeature feature : features) {
            builder.append(feature.getIdName());
            builder.append(" OR ");
        }
        builder.setLength(builder.length() - 4);
        return builder.toString();
    }

    protected EObject getTarget(String errorDescription) {
        int begin = errorDescription.indexOf(":");
        String id = errorDescription.substring(begin + 2);
        return this.resource.getEObject(id.trim());
    }
}

