/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm.fama.transformer;

import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.ExcludesFeature;
import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfm.RequiresFeature;
import es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature;
import es.us.isa.FAMA.models.FAMAAttributedfeatureModel.AttributedFeature;
import es.us.isa.FAMA.models.FAMAAttributedfeatureModel.ComplexConstraint;
import es.us.isa.FAMA.models.FAMAAttributedfeatureModel.FAMAAttributedFeatureModel;
import es.us.isa.FAMA.models.FAMAAttributedfeatureModel.Relation;
import es.us.isa.FAMA.models.featureModel.Cardinality;
import es.us.isa.FAMA.models.featureModel.Constraint;
import es.us.isa.FAMA.models.variabilityModel.VariabilityModel;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DfmToFamaTransformer {
    protected DocumentFeatureModel dfm;
    protected FAMAAttributedFeatureModel vm;

    public DfmToFamaTransformer(DocumentFeatureModel dfm) {
        this.dfm = dfm;
    }

    public VariabilityModel convert() {
        if (this.vm == null) {
            AttributedFeature rootFeature = new AttributedFeature(this.dfm.getName());
            DfmToFamaTransformer.createCorrespondingChildren(rootFeature, (Collection<DocumentFeature>)this.dfm.getFeatures());
            this.vm = new FAMAAttributedFeatureModel(rootFeature);
            this.vm.getConstraints().addAll(DfmToFamaTransformer.buildConstraints(this.dfm));
        }
        return this.vm;
    }

    protected static void createCorrespondingChildren(AttributedFeature parentAF, Collection<DocumentFeature> childDFs) {
        Relation orRelation = null;
        Relation altRelation = null;
        for (DocumentFeature df : childDFs) {
            AttributedFeature childAf = new AttributedFeature(df.getIdName());
            Relation rel = null;
            if (df.getType() == FeatureType.MANDATORY) {
                rel = new Relation("MAN: " + EcoreUtil.getURI((EObject)df).fragment());
                rel.addCardinality(new Cardinality(1, 1));
                parentAF.addRelation(rel);
            } else if (df.getType() == FeatureType.OPTIONAL) {
                rel = new Relation("OPT: " + EcoreUtil.getURI((EObject)df).fragment());
                rel.addCardinality(new Cardinality(0, 1));
                parentAF.addRelation(rel);
            } else if (df.getType() == FeatureType.OR) {
                if (orRelation == null) {
                    orRelation = new Relation("OR: " + EcoreUtil.getURI((EObject)df.eContainer()).fragment());
                    parentAF.addRelation(orRelation);
                }
                rel = orRelation;
            } else if (df.getType() == FeatureType.ALTERNATIVE) {
                if (altRelation == null) {
                    altRelation = new Relation("ALT: " + EcoreUtil.getURI((EObject)df.eContainer()).fragment());
                    parentAF.addRelation(altRelation);
                    altRelation.addCardinality(new Cardinality(1, 1));
                }
                rel = altRelation;
            }
            rel.addDestination(childAf);
            DfmToFamaTransformer.createCorrespondingChildren(childAf, DfmToFamaTransformer.getChildren((EObject)df));
        }
        if (orRelation != null) {
            orRelation.addCardinality(new Cardinality(1, orRelation.getNumberOfDestination()));
        }
    }

    protected static Collection<DocumentFeature> getChildren(EObject dfModelElement) {
        ArrayList<DocumentFeature> result = new ArrayList<DocumentFeature>();
        if (dfModelElement instanceof DocumentFeatureModel) {
            result.addAll((Collection<DocumentFeature>)((DocumentFeatureModel)dfModelElement).getFeatures());
        } else if (dfModelElement instanceof ContentDocumentFeature) {
            result.addAll((Collection<DocumentFeature>)((ContentDocumentFeature)dfModelElement).getChildren());
        } else if (dfModelElement instanceof TechnologyDocumentFeature) {
            result.addAll((Collection<DocumentFeature>)((TechnologyDocumentFeature)dfModelElement).getChildren());
        }
        return result;
    }

    protected static Collection<Constraint> buildConstraints(DocumentFeatureModel dfm) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        TreeIterator it = EcoreUtil.getAllContents((EObject)dfm, (boolean)true);
        while (it.hasNext()) {
            ComplexConstraint complexConstraint;
            StringBuilder builder;
            EObject dfmElement = (EObject)it.next();
            if (dfmElement instanceof RequiresFeature) {
                builder = new StringBuilder();
                RequiresFeature requiresFeature = (RequiresFeature)dfmElement;
                builder.append(requiresFeature.getOwnerFeature().getIdName());
                builder.append(" IMPLIES (");
                for (DocumentFeature childDfm : requiresFeature.getCandidates()) {
                    builder.append(childDfm.getIdName());
                    builder.append(" OR ");
                }
                builder.setLength(builder.length() - 4);
                builder.append(");");
                complexConstraint = new ComplexConstraint(builder.toString());
                complexConstraint.setName("REQ: " + EcoreUtil.getURI((EObject)requiresFeature).fragment());
                constraints.add((Constraint)complexConstraint);
                continue;
            }
            if (!(dfmElement instanceof ExcludesFeature)) continue;
            builder = new StringBuilder();
            ExcludesFeature excludesFeature = (ExcludesFeature)dfmElement;
            builder.append(excludesFeature.getOwnerFeature().getIdName());
            builder.append(" IMPLIES (");
            for (DocumentFeature childDfm : excludesFeature.getCandidates()) {
                builder.append(" NOT ");
                builder.append(childDfm.getIdName());
                builder.append(" OR ");
            }
            builder.setLength(builder.length() - 4);
            builder.append(");");
            complexConstraint = new ComplexConstraint(builder.toString());
            complexConstraint.setName("EXC: " + EcoreUtil.getURI((EObject)excludesFeature).fragment());
            constraints.add((Constraint)complexConstraint);
        }
        return constraints;
    }
}

