package es.upv.dsic.issi.dplfw.dfm.fama.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;

import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.ExcludesFeature;
import es.upv.dsic.issi.dplfw.dfm.RequiresFeature;
import es.upv.dsic.issi.dplfw.dfm.fama.transformer.DfmToFamaTransformer;
import es.upv.dsic.issi.dplfw.fama.FamaDplfwBridePlugin;
import es.us.isa.FAMA.Reasoner.QuestionTrader;
import es.us.isa.FAMA.Reasoner.questions.DetectErrorsQuestion;
import es.us.isa.FAMA.Reasoner.questions.ExplainErrorsQuestion;
import es.us.isa.FAMA.errors.Error;
import es.us.isa.FAMA.errors.Explanation;
import es.us.isa.FAMA.models.featureModel.GenericRelation;
import es.us.isa.FAMA.models.variabilityModel.VariabilityModel;

public class FamaBatchConstraints extends AbstractModelConstraint {

	private Resource resource;

	@Override
	public IStatus validate(IValidationContext context) {

		List<IStatus> statuses = new ArrayList<IStatus>();
		EObject eObject = context.getTarget();
		resource = eObject.eResource();
		EMFEventType eType = context.getEventType();
		
		// In the case of batch mode.
		if (eType == EMFEventType.NULL) {
			Diagnostic diagnostic = Diagnostician.INSTANCE.validate(resource.getContents().get(0));
			
			if (eObject instanceof DocumentFeatureModel
					&& diagnostic.getSeverity() == Diagnostic.OK) {
				// Model validation
				DocumentFeatureModel dfm = (DocumentFeatureModel) eObject;
				VariabilityModel vm = new DfmToFamaTransformer(dfm).convert();
				
		
				// Set the model
				QuestionTrader qt = FamaDplfwBridePlugin.getDefault().getQuestionTrader();
				qt.setVariabilityModel(vm);
		
				// Detect Errors...
				qt.setSelectedReasoner("ChocoAtt");
				DetectErrorsQuestion detectErrQuest = (DetectErrorsQuestion) qt.createQuestion("DetectErrors");
				detectErrQuest.setObservations(vm.getObservations());
				qt.ask(detectErrQuest);
				Collection<Error> errors = detectErrQuest.getErrors();
		
				// If model has errors...
				if (!errors.isEmpty()) {
					// Get explanations...
					qt.setSelectedReasoner("ChocoAtt4Exp");
					ExplainErrorsQuestion explainErrQuest = (ExplainErrorsQuestion) qt.createQuestion("Explanations");
					explainErrQuest.setErrors(errors);
					qt.ask(explainErrQuest);
					// Update errors with explanations
					errors = explainErrQuest.getErrors();
		
					for (Error error : errors) {
						List<IStatus> childStatuses = new ArrayList<IStatus>();
						Collection<Explanation> explanations = error.getExplanations();

						IStatus errorStatus = ConstraintStatus.createStatus(
								context,
								getTarget(error.toString()),
								null,
								ConstraintStatus.ERROR,
								1, 
								error.toString(),
								new Object[]{});

						statuses.add(errorStatus);
						
						Set<GenericRelation> relations = new HashSet<GenericRelation>();
						for (Explanation explanation : explanations) { 
							GenericRelation firstRelation = explanation.getRelations().iterator().next();
							if (!relations.contains(firstRelation)) {
								relations.add(firstRelation);
								childStatuses.add(ConstraintStatus.createStatus(
										context,
										getTarget(explanation.toString()),
										null,
										ConstraintStatus.INFO,
										1, 
										buildExplanationText(explanation),
										new Object[]{}));
							}
						}
						if (!childStatuses.isEmpty()) {
							IStatus multiStatus = (MultiStatus) ConstraintStatus.createMultiStatus(
									context,
									String.format("Explanations for \"%s\"", error.toString()),
									null,
									childStatuses);
							statuses.add(multiStatus);
						}
					}
				}
			} else {
				statuses.add(ConstraintStatus.createStatus(
						context,
						null,
						"Unable to analyse syntactically invalid feature model",
						new Object[] {}));
			}
		}
		
		if (!statuses.isEmpty()) {
			return ConstraintStatus.createMultiStatus(context, statuses);
		} else {
			return context.createSuccessStatus();
		}
	}

	private String buildExplanationText(Explanation explanation) {
		EObject target = getTarget(explanation.toString());
		String explanationText = explanation.toString();
		
		if (target != null) {
			if (explanationText.startsWith("MAN: ")) {
				return String.format("Feature %s is mandatory",
						((DocumentFeature) target).getIdName());
			} else if (explanationText.startsWith("EXC: ")) {
				return String.format("Feature %s excludes (%s)",
						((ExcludesFeature) target).getOwnerFeature().getIdName(),
						buildOrText(((ExcludesFeature) target).getCandidates()));
			} else if (explanationText.startsWith("REQ: ")) {
				return String.format("Feature %s requires (%s)",
						((RequiresFeature) target).getOwnerFeature().getIdName(),
						buildOrText(((RequiresFeature) target).getCandidates()));
			}
		}

		return explanation.toString();
	}
	
	private String buildOrText(List<DocumentFeature> features) {
		StringBuilder builder = new StringBuilder();
		for (DocumentFeature feature : features) {
			builder.append(feature.getIdName());
			builder.append(" OR ");
		}
		builder.setLength(builder.length() - 4);
		return builder.toString();
	}

	protected EObject getTarget(String errorDescription) {
		int begin = errorDescription.indexOf(":");
		String id = errorDescription.substring(begin + 2);
		return resource.getEObject(id.trim());
	}
}
