package es.upv.dsic.issi.dplfw.dfm.fama.transformer;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.ExcludesFeature;
import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfm.RequiresFeature;
import es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature;
import es.us.isa.FAMA.models.FAMAAttributedfeatureModel.AttributedFeature;
import es.us.isa.FAMA.models.FAMAAttributedfeatureModel.ComplexConstraint;
import es.us.isa.FAMA.models.FAMAAttributedfeatureModel.FAMAAttributedFeatureModel;
import es.us.isa.FAMA.models.FAMAAttributedfeatureModel.Relation;
import es.us.isa.FAMA.models.featureModel.Cardinality;
import es.us.isa.FAMA.models.featureModel.Constraint;
import es.us.isa.FAMA.models.variabilityModel.VariabilityModel;

public class DfmToFamaTransformer {

	protected DocumentFeatureModel dfm;
	protected FAMAAttributedFeatureModel vm;
	
	
	public DfmToFamaTransformer(DocumentFeatureModel dfm) {
		this.dfm = dfm;
	}
	
	public VariabilityModel convert() {
		if (vm == null) {
			
			AttributedFeature rootFeature = new AttributedFeature(dfm.getName());
			createCorrespondingChildren(rootFeature, dfm.getFeatures());
	
			vm = new FAMAAttributedFeatureModel(rootFeature);
			vm.getConstraints().addAll(buildConstraints(dfm));
		
		}
		return vm;
	}
	
	
	protected static void createCorrespondingChildren(AttributedFeature parentAF, Collection<DocumentFeature> childDFs) {
		Relation orRelation = null;
		Relation altRelation = null;
		
		for (DocumentFeature df : childDFs) {
			AttributedFeature childAf = new AttributedFeature(df.getIdName());

			Relation rel = null;
			
			if (df.getType() == FeatureType.MANDATORY) {
				rel = new Relation("MAN: " + EcoreUtil.getURI(df).fragment());
				rel.addCardinality(new Cardinality(1, 1));
				parentAF.addRelation(rel);
			} else if (df.getType() == FeatureType.OPTIONAL) {
				rel = new Relation("OPT: " + EcoreUtil.getURI(df).fragment());
				rel.addCardinality(new Cardinality(0, 1));
				parentAF.addRelation(rel);
			} else if (df.getType() == FeatureType.OR) {
				if (orRelation == null) {
					orRelation = new Relation("OR: " + EcoreUtil.getURI(df.eContainer()).fragment());
					parentAF.addRelation(orRelation);
					// We set the cardinality when we exit the loop
				}
				rel = orRelation;
			} else if (df.getType() == FeatureType.ALTERNATIVE) {
				if (altRelation == null) {
					altRelation = new Relation("ALT: " + EcoreUtil.getURI(df.eContainer()).fragment());
					parentAF.addRelation(altRelation);
					altRelation.addCardinality(new Cardinality(1, 1));
				}
				rel = altRelation;
			}
			rel.addDestination(childAf);
			createCorrespondingChildren(childAf, getChildren(df));
		}
		// Process the groups...
		if (orRelation != null) {
			// Set the cardinality
			orRelation.addCardinality(new Cardinality(1, orRelation.getNumberOfDestination()));
		}
	}

	
	protected static Collection<DocumentFeature> getChildren(EObject dfModelElement) {
		Collection<DocumentFeature> result = new ArrayList<DocumentFeature>();
		if (dfModelElement instanceof DocumentFeatureModel) {
			result.addAll(((DocumentFeatureModel) dfModelElement).getFeatures());
		} else if (dfModelElement instanceof ContentDocumentFeature) {
			result.addAll(((ContentDocumentFeature) dfModelElement).getChildren());
		} else if (dfModelElement instanceof TechnologyDocumentFeature) {
			result.addAll(((TechnologyDocumentFeature) dfModelElement).getChildren());
		}
		return result;
	}
	
	
	protected static Collection<Constraint> buildConstraints(DocumentFeatureModel dfm) {
		Collection<Constraint> constraints = new ArrayList<Constraint>();
		
		for (TreeIterator<EObject> it = EcoreUtil.getAllContents(dfm, true); it.hasNext();) {
			EObject dfmElement = it.next();
			if (dfmElement instanceof RequiresFeature) {
				StringBuilder builder = new StringBuilder();
				RequiresFeature requiresFeature = (RequiresFeature) dfmElement;
				builder.append(requiresFeature.getOwnerFeature().getIdName());
				builder.append(" IMPLIES (");
				for (DocumentFeature childDfm : requiresFeature.getCandidates()) {
					builder.append(childDfm.getIdName());
					builder.append(" OR ");
				}
				builder.setLength(builder.length() - 4);
				builder.append(");");
				ComplexConstraint complexConstraint = new ComplexConstraint(builder.toString());
				complexConstraint.setName("REQ: " + EcoreUtil.getURI(requiresFeature).fragment());
				constraints.add(complexConstraint);
			} else if (dfmElement instanceof ExcludesFeature) {
				StringBuilder builder = new StringBuilder();
				ExcludesFeature excludesFeature = (ExcludesFeature) dfmElement;
				builder.append(excludesFeature.getOwnerFeature().getIdName());
				builder.append(" IMPLIES (");
				for (DocumentFeature childDfm : excludesFeature.getCandidates()) {
					builder.append(" NOT ");
					builder.append(childDfm.getIdName());
					builder.append(" OR ");
				}
				builder.setLength(builder.length() - 4);
				builder.append(");");
				ComplexConstraint complexConstraint = new ComplexConstraint(builder.toString());
				complexConstraint.setName("EXC: " + EcoreUtil.getURI(excludesFeature).fragment());
				constraints.add(complexConstraint);
			}

		}
		return constraints;
	}
	
}
