/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm.presentation.validation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ValidationEvent;

public class ProblemsReporter
implements IValidationListener {
    public void validationOccurred(ValidationEvent event) {
        Set<IResource> affectedResources = ProblemsReporter.collectResources(event.getValidationResults());
        for (IResource resource : affectedResources) {
            try {
                ProblemsReporter.deleteResourceMarkers(resource);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        for (IConstraintStatus status : event.getValidationResults()) {
            if (status.isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus childStatus = iStatusArray[n2];
                    this.createMarkerForStatus((IConstraintStatus)childStatus, status.getMessage());
                    ++n2;
                }
                continue;
            }
            this.createMarkerForStatus(status);
        }
    }

    private IMarker createMarkerForStatus(IConstraintStatus status, String message) {
        IMarker marker = this.createMarkerForStatus(status);
        if (marker != null) {
            try {
                marker.setAttribute("message", (Object)(String.valueOf(message) + " -> " + status.getMessage()));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return marker;
    }

    private IMarker createMarkerForStatus(IConstraintStatus status) {
        EObject eObject = status.getTarget();
        String eObjURI = EcoreUtil.getURI((EObject)eObject).toString();
        String eObjFragment = EcoreUtil.getURI((EObject)eObject).fragment();
        IFile file = ProblemsReporter.getIResourceFromEObject(eObject);
        try {
            if (!status.isOK()) {
                IMarker newMarker = file.createMarker("org.eclipse.emf.validation.problem");
                newMarker.setAttribute("location", (Object)eObjFragment);
                newMarker.setAttribute("severity", status.getSeverity() / 2);
                newMarker.setAttribute("message", (Object)status.getMessage());
                newMarker.setAttribute("uri", (Object)eObjURI);
                newMarker.setAttribute("sourceId", status.getCode());
                return newMarker;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void deleteResourceMarkers(IResource resource) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = resource.findMarkers("org.eclipse.emf.validation.problem", true, 0);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
    }

    private static Set<IResource> collectResources(List<IConstraintStatus> statuses) {
        HashSet<IResource> set = new HashSet<IResource>();
        for (IConstraintStatus status : statuses) {
            if (status.getTarget() == null) continue;
            set.add((IResource)ProblemsReporter.getIResourceFromEObject(status.getTarget()));
        }
        return set;
    }

    private static IFile getIResourceFromEObject(EObject eObject) {
        String resourcePath = eObject.eResource().getURI().toPlatformString(true);
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resourcePath));
    }
}

