/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class TextChangeHelper
implements Listener {
    private boolean nonUserChange;

    public void startNonUserChange() {
        if (this.nonUserChange) {
            throw new IllegalStateException("we already started a non user change");
        }
        this.nonUserChange = true;
    }

    public void finishNonUserChange() {
        if (!this.nonUserChange) {
            throw new IllegalStateException("we are not in a non user change");
        }
        this.nonUserChange = false;
    }

    public boolean isNonUserChange() {
        return this.nonUserChange;
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 1: {
                if (event.character != '\r') break;
                this.textChanged((Control)event.widget);
                break;
            }
            case 16: {
                this.textChanged((Control)event.widget);
            }
        }
    }

    public abstract void textChanged(Control var1);

    public void startListeningTo(Control control) {
        control.addListener(16, (Listener)this);
        control.addListener(24, (Listener)this);
    }

    public void startListeningForEnter(Control control) {
        control.addListener(1, (Listener)this);
    }

    public void stopListeningTo(Control control) {
        if (control != null && !control.isDisposed()) {
            control.removeListener(16, (Listener)this);
            control.removeListener(24, (Listener)this);
            control.removeListener(1, (Listener)this);
        }
    }
}

