/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.presentation.DfmEditor;
import es.upv.dsic.issi.dplfw.dfm.presentation.properties.AbstractDfmPropertySection;
import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ICredentialsManager;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.dialogs.SearchActorsDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ReadersPropertySection
extends AbstractDfmPropertySection {
    private TableViewer viewer;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        CLabel nameLabel = this.getWidgetFactory().createCLabel(composite, "Readers:");
        Table table = this.getWidgetFactory().createTable(composite, 66304);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        TableViewerColumn nameCol = new TableViewerColumn(this.viewer, 0);
        nameCol.getColumn().setWidth(400);
        nameCol.getColumn().setText("Actor name");
        nameCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                UUID uuid = (UUID)element;
                ICredentialsManager manager = CredentialsManagerPlugin.getDefault().getManagersRegistry().getActiveManager();
                String name = manager.resolveActorName(uuid);
                return name != null ? name : "<unable to resolve actor name>";
            }
        });
        TableViewerColumn uuidCol = new TableViewerColumn(this.viewer, 0);
        uuidCol.getColumn().setWidth(230);
        uuidCol.getColumn().setText("UUID");
        uuidCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                UUID uuid = (UUID)element;
                return uuid != null ? uuid.toString() : "<null>";
            }
        });
        Composite buttonsComposite = this.getWidgetFactory().createFlatFormComposite(composite);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        buttonsComposite.setLayout((Layout)rowLayout);
        Button editButton = this.getWidgetFactory().createButton(buttonsComposite, "Edit...", 8);
        Button propagateButton = this.getWidgetFactory().createButton(buttonsComposite, "Propagate to children", 8);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReadersPropertySection.this.handleEdit();
            }
        });
        propagateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReadersPropertySection.this.handlePropagate();
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)table, -5);
        data.top = new FormAttachment((Control)table, 0, 128);
        nameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{"Responsible:", "Readers:", "Writers:"}));
        data.right = new FormAttachment((Control)buttonsComposite, -5);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        table.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)table, 0, 128);
        buttonsComposite.setLayoutData((Object)data);
    }

    protected void handleEdit() {
        List<UUID> value = this.getFeatureValue();
        SearchActorsDialog dialog = new SearchActorsDialog(this.getPart().getSite().getShell(), value, 2);
        dialog.create();
        if (dialog.open() == 0) {
            ArrayList<UUID> uuids = new ArrayList<UUID>();
            for (Actor actor : dialog.getActors()) {
                uuids.add(actor.getUuid());
            }
            EditingDomain editingDomain = ((DfmEditor)this.getPart()).getEditingDomain();
            Command command = SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), uuids);
            if (command.canExecute()) {
                editingDomain.getCommandStack().execute(command);
            }
        }
        this.viewer.refresh();
    }

    protected void handlePropagate() {
        EditingDomain editingDomain = ((DfmEditor)this.getPart()).getEditingDomain();
        class PropagateCommand
        extends ChangeCommand {
            private ContentDocumentFeature cdf;

            protected PropagateCommand(ContentDocumentFeature cdf) {
                super(new ChangeRecorder(), (Notifier)cdf);
                this.cdf = cdf;
            }

            protected void doExecute() {
                this.cdf.propagateReaders();
            }

            public String getLabel() {
                return "Propagate to children";
            }
        }
        PropagateCommand command = new PropagateCommand((ContentDocumentFeature)this.eObject);
        if (command.canExecute()) {
            editingDomain.getCommandStack().execute((Command)command);
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    protected EAttribute getFeature() {
        return DfmPackage.eINSTANCE.getContentDocumentFeature_Readers();
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.viewer != null) {
            this.viewer.setInput(this.getFeatureValue());
        }
    }

    protected List<UUID> getFeatureValue() {
        return (List)this.eObject.eGet((EStructuralFeature)this.getFeature());
    }
}

