/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import es.upv.dsic.issi.dplfw.dfm.presentation.DfmEditor;
import es.upv.dsic.issi.dplfw.dfm.presentation.properties.AbstractDfmPropertySection;
import es.upv.dsic.issi.dplfw.dfm.presentation.properties.TextChangeHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractTextPropertySection
extends AbstractDfmPropertySection {
    protected Text text;
    protected CLabel nameLabel;
    protected TextChangeHelper listener;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.text = this.getWidgetFactory().createText(composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.text.setLayoutData((Object)data);
        this.nameLabel = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.text, -5);
        data.top = new FormAttachment((Control)this.text, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        this.listener = new TextChangeHelper(){

            @Override
            public void textChanged(Control control) {
                AbstractTextPropertySection.this.handleTextModified();
            }
        };
        this.listener.startListeningTo((Control)this.text);
        this.listener.startListeningForEnter((Control)this.text);
    }

    protected void handleTextModified() {
        String newText = this.text.getText();
        boolean equals = this.isEqual(newText);
        if (!equals) {
            EditingDomain editingDomain = ((DfmEditor)this.getPart()).getEditingDomain();
            String value = newText;
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        this.text.setText(this.getFeatureValueAsText());
    }

    protected abstract boolean isEqual(String var1);

    protected abstract EAttribute getFeature();

    protected abstract String getFeatureValueAsText();

    protected abstract String getLabelText();
}

