/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import es.upv.dsic.issi.dplfw.dfm.presentation.DfmEditor;
import es.upv.dsic.issi.dplfw.dfm.presentation.properties.AbstractDfmPropertySection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractTablePropertySection
extends AbstractDfmPropertySection {
    protected Table table;
    protected List<TableColumn> columns;
    protected Button addButton;
    protected Button removeButton;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.table = this.getWidgetFactory().createTable(composite, 66304);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        List<?> labels = this.getColumnLabelText();
        this.columns = new ArrayList<TableColumn>();
        Iterator<?> i = labels.iterator();
        while (i.hasNext()) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText((String)i.next());
            this.columns.add(column);
        }
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 11;
        gc.dispose();
        shell.dispose();
        this.addButton = this.getWidgetFactory().createButton(composite, MessageFormat.format("Add {0}...", this.getButtonLabelText()), 8);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.top = new FormAttachment(100, -buttonHeight);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditingDomain editingDomain = ((DfmEditor)AbstractTablePropertySection.this.getPart()).getEditingDomain();
                AddCommand addCommand = (AddCommand)AddCommand.create((EditingDomain)editingDomain, (Object)AbstractTablePropertySection.this.eObject, (Object)AbstractTablePropertySection.this.getFeature(), (Object)AbstractTablePropertySection.this.getNewChild());
                editingDomain.getCommandStack().execute((Command)addCommand);
            }
        });
        this.removeButton = this.getWidgetFactory().createButton(composite, MessageFormat.format("Delete {0}", this.getButtonLabelText()), 8);
        data = new FormData();
        data.left = new FormAttachment((Control)this.addButton, 4, 1024);
        data.bottom = new FormAttachment(100, 0);
        data.top = new FormAttachment(100, -buttonHeight);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditingDomain editingDomain = ((DfmEditor)AbstractTablePropertySection.this.getPart()).getEditingDomain();
                Object object = AbstractTablePropertySection.this.table.getSelection()[0].getData();
                editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, (Object)object));
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment((Control)this.addButton, -4);
        data.width = 400;
        this.table.setLayoutData((Object)data);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractTablePropertySection.this.removeButton.setEnabled(true);
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object object = AbstractTablePropertySection.this.table.getSelection()[0].getData();
                AbstractTablePropertySection.this.propertySheetPage.getEditor().getViewer().setSelection((ISelection)new StructuredSelection(object), true);
                AbstractTablePropertySection.this.propertySheetPage.getEditor().setFocus();
            }
        });
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void refresh() {
        this.table.removeAll();
        this.removeButton.setEnabled(false);
        for (Object next : this.getOwnedRows()) {
            String key = this.getKeyForRow(next);
            int k = 0;
            int size = this.table.getItemCount();
            while (k < size) {
                String currentKey = this.table.getItem(k).getText();
                if (key.compareToIgnoreCase(currentKey) < 0) break;
                ++k;
            }
            TableItem item = new TableItem(this.table, 0, k);
            String[] values = new String[this.columns.size()];
            List<?> valuesForRow = this.getValuesForRow(next);
            int j = 0;
            while (j < this.columns.size()) {
                values[j] = (String)valuesForRow.get(j);
                ++j;
            }
            item.setText(values);
            item.setData(next);
        }
        Iterator<Object> i = this.columns.iterator();
        while (i.hasNext()) {
            ((TableColumn)i.next()).pack();
        }
    }

    protected abstract String getButtonLabelText();

    protected abstract List<?> getOwnedRows();

    protected abstract EAttribute getFeature();

    protected abstract String getKeyForRow(Object var1);

    protected abstract List<?> getValuesForRow(Object var1);

    protected abstract List<?> getColumnLabelText();

    protected abstract Object getNewChild();
}

