/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfm.presentation.DfmEditor;
import es.upv.dsic.issi.dplfw.dfm.presentation.properties.AbstractDfmPropertySection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractEnumPropertySection
extends AbstractDfmPropertySection {
    List<Button> buttons = new ArrayList<Button>();

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        EEnum eEnum = this.getEEnum();
        Composite radioComposite = this.getWidgetFactory().createFlatFormComposite(composite);
        FormData data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        radioComposite.setLayoutData((Object)data);
        radioComposite.setLayout((Layout)new RowLayout(512));
        for (EEnumLiteral literal : eEnum.getELiterals()) {
            Button button = this.getWidgetFactory().createButton(radioComposite, StringUtils.capitalize((String)literal.getName()), 16);
            button.setData((Object)literal.getName());
            this.buttons.add(button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractEnumPropertySection.this.handleSelectionModified();
                }
            });
        }
        CLabel nameLabel = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)radioComposite, -5);
        data.top = new FormAttachment((Control)radioComposite, 0, 128);
        nameLabel.setLayoutData((Object)data);
    }

    protected EEnum getEEnum() {
        EClassifier eClassifier = this.getFeature().getEType();
        return (EEnum)eClassifier;
    }

    protected void handleSelectionModified() {
        String newText = "";
        for (Button button : this.buttons) {
            if (!button.getSelection()) continue;
            newText = (String)button.getData();
            break;
        }
        boolean equals = this.isEqual(newText);
        if (!equals) {
            EditingDomain editingDomain = ((DfmEditor)this.getPart()).getEditingDomain();
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), (Object)FeatureType.get((String)newText)));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)FeatureType.get((String)newText)));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        for (Button button : this.buttons) {
            button.setSelection(this.isEqual((String)button.getData()));
        }
    }

    protected boolean isEqual(String newText) {
        return this.getFeatureValueAsText().equals(newText);
    }

    protected abstract EAttribute getFeature();

    protected String getFeatureValueAsText() {
        FeatureType type = (FeatureType)this.eObject.eGet((EStructuralFeature)this.getFeature());
        if (type == null) {
            return "";
        }
        return type.getName();
    }

    protected abstract String getLabelText();
}

