/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfm.presentation.actions;

import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.presentation.validation.ValidationDelegateClientSelector;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AnalyseModelAction
extends ValidateAction {
    public AnalyseModelAction() {
        this.setText("&Analyse");
    }

    public void run() {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(final IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.validation.problem", 0, "Errors found!", null);
                    diagnostic.add(AnalyseModelAction.this.validate(progressMonitor));
                    ValidationDelegateClientSelector.running = true;
                    IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
                    validator.setIncludeLiveConstraints(true);
                    validator.setReportSuccesses(true);
                    IStatus status = validator.validate((Collection)AnalyseModelAction.this.selectedObjects);
                    ValidationDelegateClientSelector.running = false;
                    diagnostic.add(BasicDiagnostic.toDiagnostic((IStatus)status));
                    BasicDiagnostic finalDiagnostic = diagnostic;
                    shell.getDisplay().asyncExec(new Runnable((Diagnostic)finalDiagnostic){
                        private final /* synthetic */ Diagnostic val$finalDiagnostic;
                        {
                            this.val$finalDiagnostic = diagnostic;
                        }

                        @Override
                        public void run() {
                            if (progressMonitor.isCanceled()) {
                                AnalyseModelAction.this.handleDiagnostic(Diagnostic.CANCEL_INSTANCE);
                            } else {
                                AnalyseModelAction.this.handleDiagnostic(this.val$finalDiagnostic);
                            }
                        }
                    });
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        if (this.eclipseResourcesUtil != null) {
            runnableWithProgress = this.eclipseResourcesUtil.getWorkspaceModifyOperation(runnableWithProgress);
        }
        try {
            new ProgressMonitorDialog(shell).run(true, true, runnableWithProgress);
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log((Object)exception);
        }
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        Resource resource;
        int severity = diagnostic.getSeverity();
        String title = null;
        String message = null;
        if (severity == 4 || severity == 2) {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title");
            message = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message");
        } else {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationResults_title");
            message = EMFEditUIPlugin.INSTANCE.getString(severity == 0 ? "_UI_ValidationOK_message" : "_UI_ValidationResults_message");
        }
        if (diagnostic.getSeverity() == 0) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
        } else {
            DiagnosticDialog.open((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (Diagnostic)diagnostic);
        }
        Resource resource2 = resource = this.eclipseResourcesUtil != null ? (Resource)this.domain.getResourceSet().getResources().get(0) : null;
        if (resource != null) {
            this.eclipseResourcesUtil.deleteMarkers((Object)resource);
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                if (!childDiagnostic.getSource().equals("org.eclipse.emf.ecore")) continue;
                for (Diagnostic childChildDiagnostic : childDiagnostic.getChildren()) {
                    this.eclipseResourcesUtil.createMarkers(resource, childChildDiagnostic);
                }
            }
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        super.updateSelection(selection);
        if (this.selectedObjects != null && !this.selectedObjects.isEmpty()) {
            return this.selectedObjects.get(0) instanceof DocumentFeatureModel;
        }
        return false;
    }
}

