package es.upv.dsic.issi.dplfw.dfm.presentation.validation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.marker.MarkerUtil;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ValidationEvent;

public class ProblemsReporter implements IValidationListener {
	
	public void validationOccurred(ValidationEvent event) {
		
		// Collect the Resources whose state has been checked
 		Set<IResource> affectedResources = collectResources(event.getValidationResults());

		// Delete the markers associated for the affected Resources
		for (Iterator<IResource> it = affectedResources.iterator(); it.hasNext();) {
			IResource resource = (IResource) it.next();
			try {
				// Markers are stored in a Workspace IResource
				deleteResourceMarkers(resource);
			} catch (CoreException e) {
				e.printStackTrace();
			}
		}

		// We have cleaned obsolete statuses
		// Let's iterate over the new statuses an recreate the new valid ones
        for (IConstraintStatus status : event.getValidationResults()) {
        	if (status.isMultiStatus()) {
        		for (IStatus childStatus : status.getChildren()) {
        			createMarkerForStatus((IConstraintStatus) childStatus, status.getMessage());
        		}
        	} else {
        		createMarkerForStatus(status);
        	}        		
        }
    }

	private IMarker createMarkerForStatus(IConstraintStatus status, String message) {
		IMarker marker = createMarkerForStatus(status);
		if (marker != null) {
			try {
				marker.setAttribute(IMarker.MESSAGE, message + " -> " + status.getMessage());
			} catch (CoreException e) {
				e.printStackTrace();
			}
		}
		return marker;
	}

	private IMarker createMarkerForStatus(IConstraintStatus status) {
		EObject eObject = status.getTarget();
		String eObjURI = EcoreUtil.getURI(eObject).toString();
		String eObjFragment = EcoreUtil.getURI(eObject).fragment();
		IFile file = getIResourceFromEObject(eObject);
		
		try {
			if (!status.isOK()) {
				IMarker newMarker = file.createMarker(MarkerUtil.VALIDATION_MARKER_TYPE);
				newMarker.setAttribute(IMarker.LOCATION, eObjFragment);
				newMarker.setAttribute(IMarker.SEVERITY, status.getSeverity() / 2); // Los códigos de IMarker.SEVERITY no corresponden con IStatus.SEVERITY
				newMarker.setAttribute(IMarker.MESSAGE, status.getMessage());
				newMarker.setAttribute(EValidator.URI_ATTRIBUTE, eObjURI);
				newMarker.setAttribute(IMarker.SOURCE_ID, status.getCode());
				return newMarker;
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	private static void deleteResourceMarkers(IResource resource) throws CoreException {
		IMarker[] markers = resource.findMarkers(MarkerUtil.VALIDATION_MARKER_TYPE, true, IResource.DEPTH_ZERO);
		for (IMarker marker : markers) {
			marker.delete();
		}
	}
	
	private static Set<IResource> collectResources(List<IConstraintStatus> statuses) {
		Set<IResource> set = new HashSet<IResource>();

		for (IConstraintStatus status : statuses) {
			if (status.getTarget() != null) {
				set.add(getIResourceFromEObject(status.getTarget()));
			}
		}
		
		return set;
	}

	private static IFile getIResourceFromEObject(EObject eObject) {
		String resourcePath = eObject.eResource().getURI().toPlatformString(true);
		return ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(resourcePath));
	}
}