package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.SelectInfoElementWizard;


final class SelectInfoElementsCellEditor extends ExtendedDialogCellEditor {
	
	SelectInfoElementsCellEditor(Composite composite, ILabelProvider labelProvider) {
		super(composite, labelProvider);
	}

	@Override
	protected Object openDialogBox(Control cellEditorWindow) {
		SelectInfoElementWizard wizard = new SelectInfoElementWizard(null);
		WizardDialog wizardDialog = new WizardDialog(getControl().getShell(), wizard) {
			{
				// Initialization to allow the wizard to be non-modal
				setShellStyle(SWT.SHELL_TRIM);
			}
		};
		wizardDialog.create();
		wizardDialog.setBlockOnOpen(true);
		if (wizardDialog.open() == WizardDialog.OK) {
			return wizard.getInfoElementUri();
		}
		return null;
	}
}