package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.dialogs.SearchActorsDialog;


final class SelectActorsCellEditor extends ExtendedDialogCellEditor {
	
	SelectActorsCellEditor(Composite composite, ILabelProvider labelProvider) {
		super(composite, labelProvider);
	}

	@Override
	protected Object openDialogBox(Control cellEditorWindow) {
		@SuppressWarnings("unchecked")
		List<UUID> value = (List<UUID>) getValue();
		SearchActorsDialog dialog = new SearchActorsDialog(
				getControl().getShell(), value, SWT.MULTI);
		dialog.create();
		if (dialog.open() == WizardDialog.OK) {
			List<UUID> uuids = new ArrayList<UUID>();
			for (Actor actor : dialog.getActors()) {
				uuids.add(actor.getUuid());
			}
			return uuids;
		}
		return null;
	}
}