package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import java.util.Collections;
import java.util.UUID;

import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.dialogs.SearchActorsDialog;


final class SelectActorCellEditor extends ExtendedDialogCellEditor {
	
	SelectActorCellEditor(Composite composite, ILabelProvider labelProvider) {
		super(composite, labelProvider);
	}

	@Override
	protected Object openDialogBox(Control cellEditorWindow) {
		UUID value = (UUID) getValue();
		SearchActorsDialog dialog = new SearchActorsDialog(
				getControl().getShell(), 
				Collections.singletonList(value),
				SWT.NONE);
		dialog.create();
		if (dialog.open() == WizardDialog.OK) {
			if (dialog.getActors() != null && !dialog.getActors().isEmpty()) {
				return ((Actor) dialog.getActors().toArray()[0]).getUuid();
			}
		}
		return null;
	}
}