package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.presentation.DfmEditor;
import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ICredentialsManager;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.dialogs.SearchActorsDialog;

public class ResponsiblePropertySection extends AbstractDfmPropertySection {

	private TableViewer viewer;

	@Override
	public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);
		Composite composite = getWidgetFactory().createFlatFormComposite(parent);
		

		CLabel nameLabel = getWidgetFactory().createCLabel(composite, "Responsible:");
		
		Table table = getWidgetFactory().createTable(composite, SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		viewer = new TableViewer(table);
		viewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {}
			
			@Override
			public void dispose() {}
			
			@Override
			public Object[] getElements(Object inputElement) {
				ContentDocumentFeature cdf = (ContentDocumentFeature) inputElement;
				return cdf.getResponsible() != null ? new Object[] { cdf.getResponsible() } : new Object[] {};
			}
		});
		viewer.setLabelProvider(new LabelProvider());
		
		TableViewerColumn nameCol = new TableViewerColumn(viewer, SWT.NONE);
		nameCol.getColumn().setWidth(400);
		nameCol.getColumn().setText("Actor name");
		nameCol.setLabelProvider(new ColumnLabelProvider() {
		  @Override
		  public String getText(Object element) {
			  UUID uuid = (UUID) element;
			  ICredentialsManager manager = CredentialsManagerPlugin.getDefault().getManagersRegistry().getActiveManager();
			  String name = manager.resolveActorName(uuid);
			  return name != null ? name : "<unable to resolve actor name>";
		  }
		});

		TableViewerColumn uuidCol = new TableViewerColumn(viewer, SWT.NONE);
		uuidCol.getColumn().setWidth(230);
		uuidCol.getColumn().setText("UUID");
		uuidCol.setLabelProvider(new ColumnLabelProvider() {
		  @Override
		  public String getText(Object element) {
			  UUID uuid = (UUID) element;
			  return uuid != null ? uuid.toString() : "<null>";
		  }
		});
		
		Composite buttonsComposite = getWidgetFactory().createFlatFormComposite(composite);
		RowLayout rowLayout = new RowLayout(SWT.VERTICAL);
		rowLayout.fill = true;
		rowLayout.marginTop = 0;
		rowLayout.marginBottom = 0;
		rowLayout.marginLeft = 0;
		rowLayout.marginRight = 0;
		buttonsComposite.setLayout(rowLayout);
		
		Button editButton = getWidgetFactory().createButton(buttonsComposite, "Edit...", SWT.PUSH);
		Button propagateButton = getWidgetFactory().createButton(buttonsComposite, "Propagate to children", SWT.PUSH);
		
		editButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				handleEdit();
			}
		});
		
		propagateButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				handlePropagate();
			}
		});
		
		FormData data;

		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(table, -ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(table, 0, SWT.TOP);
		nameLabel.setLayoutData(data);
		
		data = new FormData();
		data.left = new FormAttachment(0, getStandardLabelWidth(composite, new String[] { "Responsible:", "Readers:" , "Writers:" }));
		data.right = new FormAttachment(buttonsComposite, -ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(0, ITabbedPropertyConstants.VSPACE);
		data.bottom = new FormAttachment(0, 51);
		table.setLayoutData(data);
		
		data = new FormData();
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(table, 0, SWT.TOP);
		buttonsComposite.setLayoutData(data);


	}

	protected void handleEdit() {
		UUID value = getFeatureValue();
		SearchActorsDialog dialog = new SearchActorsDialog(
				getPart().getSite().getShell(), Arrays.asList(new UUID[] { value }), SWT.SINGLE);
		dialog.create();
		if (dialog.open() == WizardDialog.OK) {
			Collection<Actor> actors = dialog.getActors();
			UUID newValue = !actors.isEmpty() ? ((Actor) actors.toArray()[0]).getUuid() :  null;  
			EditingDomain editingDomain = ((DfmEditor) getPart()).getEditingDomain();
			Command command = SetCommand.create(editingDomain, eObject, getFeature(), newValue);
			if (command.canExecute()) {
				editingDomain.getCommandStack().execute(command);
			}
		}
		viewer.refresh();
	}
	
	protected void handlePropagate() {
		class PropagateCommand extends ChangeCommand {

			private ContentDocumentFeature cdf;
			
			protected PropagateCommand(ContentDocumentFeature cdf) {
				super(new ChangeRecorder(), cdf);
				this.cdf = cdf;
			}

			@Override
			protected void doExecute() {
				cdf.propagateResponsible();
			}
			@Override
			public String getLabel() {
				return "Propagate to children";
			}
		}
		EditingDomain editingDomain = ((DfmEditor) getPart()).getEditingDomain();
		Command command = new PropagateCommand((ContentDocumentFeature) eObject);
		if (command.canExecute()) {
			editingDomain.getCommandStack().execute(command);
		}
	}

	@Override
	public boolean shouldUseExtraSpace() {
		return false;
	}
	
	protected EAttribute getFeature() {
		return DfmPackage.eINSTANCE.getContentDocumentFeature_Responsible();
	}
	
	@Override
	public void setInput(IWorkbenchPart part, ISelection selection) {
		super.setInput(part, selection);
		if (viewer != null) {
			viewer.setInput(eObject);
			
		}
	}
	
	@SuppressWarnings("unchecked")
	protected UUID getFeatureValue() {
		return (UUID) eObject.eGet(getFeature());
	}
}
