package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;

import es.upv.dsic.issi.dplfw.dfm.DfmPackage;

final class ResourcePropertyDescriptor extends PropertyDescriptor {
	
	ResourcePropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
		super(object, itemPropertyDescriptor);
	}

	@Override
	public CellEditor createPropertyEditor(Composite composite) {
		if (getId().equals(
				DfmPackage.eINSTANCE.getContentDocumentFeature_InfoElementURI().getName())) {
			return new SelectInfoElementsCellEditor(composite, getLabelProvider());
		} else if (getId().equals(
				DfmPackage.eINSTANCE.getContentDocumentFeature_Editors().getName())) {
			return new SelectActorsCellEditor(composite, getLabelProvider());
		} else if (getId().equals(
				DfmPackage.eINSTANCE.getContentDocumentFeature_Readers().getName())) {
			return new SelectActorsCellEditor(composite, getLabelProvider());
		} else if (getId().equals(
				DfmPackage.eINSTANCE.getContentDocumentFeature_Responsible().getName())) {
			return new SelectActorCellEditor(composite, getLabelProvider());
		} else {
			return super.createPropertyEditor(composite);
		}		
	}
}