package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.Reference;
import es.upv.dsic.issi.dplfw.dfm.presentation.DfmEditor;
import es.upv.dsic.issi.dplfw.infoelements.VariableIEContents;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.SelectInfoElementVariablesWizard;

public class ReferenceNamePropertySection
	extends AbstractDfmPropertySection {

	private Text text;
	private SelectInfoElementVariablesWizard wizard;
	@Override
	public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);
		Composite composite = getWidgetFactory().createFlatFormComposite(parent);
		
	
		Composite buttonsComposite = getWidgetFactory().createFlatFormComposite(composite);
		RowLayout rowLayout = new RowLayout(SWT.VERTICAL);
		rowLayout.fill = true;
		rowLayout.marginTop = 0;
		rowLayout.marginBottom = 0;
		rowLayout.marginLeft = 0;
		rowLayout.marginRight = 0;
		buttonsComposite.setLayout(rowLayout);
		
		
		FormData data;

		text = getWidgetFactory().createText(composite, ""); //$NON-NLS-1$
		data = new FormData();
		data.left = new FormAttachment(0, getStandardLabelWidth(composite, new String[] {"Reference:"}));
		data.right = new FormAttachment(buttonsComposite, -ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(3, ITabbedPropertyConstants.VSPACE);
		text.setLayoutData(data);
		text.setEnabled(false);
		
		CLabel nameLabel = getWidgetFactory().createCLabel(composite, "Reference:");
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(text, -ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(text, 3, SWT.CENTER);
		nameLabel.setLayoutData(data);		
		
		data = new FormData();
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(text, -5, SWT.TOP);
		buttonsComposite.setLayoutData(data);
				
		Button editButton = getWidgetFactory().createButton(buttonsComposite, "Edit...", SWT.PUSH);
		

		editButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				handleEdit();
			}
		});
		
	}


	protected void handleEdit() {
		
		if(eObject instanceof Reference) {
			Reference ref = (Reference) eObject;
			wizard = new SelectInfoElementVariablesWizard(ref);
			WizardDialog wizardDialog = new WizardDialog(text.getShell(), wizard) {
				{
					// Initialization to allow the wizard to be non-modal
					setShellStyle(SWT.SHELL_TRIM);
				}
			};
			wizardDialog.create();
			wizardDialog.setBlockOnOpen(true);
			if (wizardDialog.open() == WizardDialog.OK) {
				VariableIEContents varIECont = wizard.getVariableIEContents();
				URI uri = wizard.getInfoElementUri().appendSegment(varIECont.getIdName());
				String referenceName = wizard.getVariableIEContents().getIdName();
				EditingDomain editingDomain = ((DfmEditor) getPart()).getEditingDomain();
				Command command = SetCommand.create(editingDomain, eObject, getFeature(), uri);
				if (command.canExecute()) {
					editingDomain.getCommandStack().execute(command);
					text.setText(referenceName);
				}
			}
		}
		
	}

	@Override
	public boolean shouldUseExtraSpace() {
		return true;
	}
	
	protected EAttribute getFeature() {
		return DfmPackage.eINSTANCE.getReference_InfoElementURI();
	}
	
	@Override
	public void setInput(IWorkbenchPart part, ISelection selection) {
		super.setInput(part, selection);
		if (text != null && getFeatureValue() != null) {
			text.setText(getFeatureValue().lastSegment());
		}
	}
	
	@SuppressWarnings("unchecked")
	protected URI getFeatureValue() {
		return (URI) eObject.eGet(getFeature());
	}
}
