package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import java.util.Iterator;

import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.presentation.DfmEditor;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.SelectInfoElementWizard;

public class InfoElementPropertySection
	extends AbstractDfmPropertySection {

	private Text text;
	private SelectInfoElementWizard wizard;
	
	@Override
	public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);
		Composite composite = getWidgetFactory().createFlatFormComposite(parent);
		
	
		Composite buttonsComposite = getWidgetFactory().createFlatFormComposite(composite);
		RowLayout rowLayout = new RowLayout(SWT.VERTICAL);
		rowLayout.fill = true;
		rowLayout.marginTop = 0;
		rowLayout.marginBottom = 0;
		rowLayout.marginLeft = 0;
		rowLayout.marginRight = 0;
		buttonsComposite.setLayout(rowLayout);
		
		
		FormData data;

		text = getWidgetFactory().createText(composite, ""); //$NON-NLS-1$
		data = new FormData();
		data.left = new FormAttachment(0, getStandardLabelWidth(composite, new String[] {"InfoElement:"}));
		data.right = new FormAttachment(buttonsComposite, -ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(3, ITabbedPropertyConstants.VSPACE);
		text.setLayoutData(data);
		text.setEnabled(false);
		
		CLabel ieURICandidateLabel = getWidgetFactory().createCLabel(composite, "InfoElement:");
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(text, -ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(text, 3, SWT.CENTER);
		ieURICandidateLabel.setLayoutData(data);		
		
	
		
		data = new FormData();
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(text, -5, SWT.CENTER);
		buttonsComposite.setLayoutData(data);
				
		Button editButton = getWidgetFactory().createButton(buttonsComposite, "Edit...", SWT.PUSH);
		
		editButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				handleEdit();
			}
		});
		
	}


	protected void handleEdit() {
		if (eObject instanceof ContentDocumentFeature) {
			wizard = new SelectInfoElementWizard(eObject);
			WizardDialog wizardDialog = new WizardDialog(text.getShell(), wizard) {
				{
					// Initialization to allow the wizard to be non-modal
					setShellStyle(SWT.SHELL_TRIM);
				}
			};
			wizardDialog.create();
			wizardDialog.setBlockOnOpen(true);
			if (wizardDialog.open() == WizardDialog.OK) {
				URI value = wizard.getInfoElementUri();
				EditingDomain editingDomain = ((DfmEditor) getPart()).getEditingDomain();
				if (eObjectList.size() == 1) {
					/* apply the property change to single selected object */
					editingDomain.getCommandStack()
							.execute(SetCommand.create(editingDomain, eObject, getFeature(), value));
				} else {
					CompoundCommand compoundCommand = new CompoundCommand();
					/* apply the property change to all selected elements */
					for (Iterator<?> i = eObjectList.iterator(); i.hasNext();) {
						EObject nextObject = (EObject) i.next();
						compoundCommand.append(SetCommand.create(editingDomain, nextObject, getFeature(), value));
					}
					editingDomain.getCommandStack().execute(compoundCommand);
				}
			}
		}
	}

	

	@Override
	public boolean shouldUseExtraSpace() {
		return false;
	}
	
	protected EAttribute getFeature() {
		return DfmPackage.eINSTANCE.getContentDocumentFeature_InfoElementURI();
	}
	
	@Override
	public void setInput(IWorkbenchPart part, ISelection selection) {
		super.setInput(part, selection);
		if (text != null && getFeatureValue() != null) {
			text.setText(getFeatureValue().toString());
		}
	}
	
	@SuppressWarnings("unchecked")
	protected URI getFeatureValue() {
		return (URI) eObject.eGet(getFeature());
	}
}
