package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import java.util.Iterator;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.presentation.DfmEditor;

public class DocumentFeatureNamePropertySection
	extends AbstractStringPropertySection {

	protected EAttribute getFeature() {
		return DfmPackage.eINSTANCE.getDocumentFeature_VisibleName();
	}

	protected String getLabelText() {
		return "Visible name:";
	}

	@Override
	protected void handleTextModified() {
		super.handleTextModified();
		EditingDomain editingDomain = ((DfmEditor) getPart()).getEditingDomain();
		if (eObjectList.size() == 1) {
			DocumentFeature df = (DocumentFeature) eObject;
			if(StringUtils.isEmpty(df.getIdName())) {
				editingDomain.getCommandStack().execute(SetCommand.create(
					editingDomain, df, DfmPackage.eINSTANCE.getDocumentFeature_IdName(), df.computeIdName()
				));
			}
		} else {
			CompoundCommand compoundCommand = new CompoundCommand();
			for (Iterator i = eObjectList.iterator(); i.hasNext();) {
				DocumentFeature df = (DocumentFeature) i.next();
				if(StringUtils.isEmpty(df.getIdName())) {
					editingDomain.getCommandStack().execute(SetCommand.create(
						editingDomain, df, DfmPackage.eINSTANCE.getDocumentFeature_IdName(), df.computeIdName()
					));
				}
			}
			editingDomain.getCommandStack().execute(compoundCommand);
		}
	}
}