package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import java.util.Iterator;

import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.presentation.DfmEditor;
import es.upv.dsic.issi.dplfw.dfm.presentation.DfmEditorPlugin;

public class DocumentFeatureIdNamePropertySection
	extends AbstractStringPropertySection {

	@Override
	public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
		super.createControls(parent, tabbedPropertySheetPage);
		
		Composite composite = nameLabel.getParent();
		FormData data;
		
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.top = new FormAttachment(0, ITabbedPropertyConstants.VSPACE);
		data.width = getStandardLabelWidth(composite, new String[] { getLabelText() }); 
		nameLabel.setLayoutData(data);

		Button buttonRefresh = getWidgetFactory().createButton(composite, "", SWT.PUSH);
		buttonRefresh.setImage(PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_ELCL_SYNCED));
		data = new FormData();
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(text, 0, SWT.CENTER);
		buttonRefresh.setLayoutData(data);

		Button buttonActivate = getWidgetFactory().createButton(composite, "", SWT.PUSH);
		buttonActivate.setImage(DfmEditorPlugin.getPlugin().getImageRegistry().get(DfmEditorPlugin.WRITE_OBJ_ICON));
		data = new FormData();
		data.right = new FormAttachment(buttonRefresh, 0);
		data.top = new FormAttachment(text, 0, SWT.CENTER);
		buttonActivate.setLayoutData(data);
	
		data = new FormData();
		data.left = new FormAttachment(nameLabel, -ITabbedPropertyConstants.HMARGIN-1);
		data.right = new FormAttachment(buttonActivate, 0);
		data.top = new FormAttachment(nameLabel, 0, SWT.CENTER);
		text.setLayoutData(data);
		text.setEnabled(false);

		buttonActivate.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				text.setEnabled(!text.isEnabled());
				if (text.isEnabled()) {
					buttonActivate.setImage(DfmEditorPlugin.getPlugin().getImageRegistry().get(DfmEditorPlugin.WRITE_OBJ_DIS_ICON));
				} else {
					buttonActivate.setImage(DfmEditorPlugin.getPlugin().getImageRegistry().get(DfmEditorPlugin.WRITE_OBJ_ICON));
				}
			}
		});
		
		buttonRefresh.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				EditingDomain editingDomain = ((DfmEditor) getPart()).getEditingDomain();
				if (eObjectList.size() == 1) {
					DocumentFeature df = (DocumentFeature) eObject;
					editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, df,
							DfmPackage.eINSTANCE.getDocumentFeature_IdName(), df.computeIdName()));
				} else {
					CompoundCommand compoundCommand = new CompoundCommand();
					for (Iterator<?> i = eObjectList.iterator(); i.hasNext();) {
						DocumentFeature df = (DocumentFeature) i.next();
						editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, df,
								DfmPackage.eINSTANCE.getDocumentFeature_IdName(), df.computeIdName()));
					}
					editingDomain.getCommandStack().execute(compoundCommand);
				}
			}
		});
	}
	
	protected EAttribute getFeature() {
		return DfmPackage.eINSTANCE.getDocumentFeature_IdName();
	}

	protected String getLabelText() {
		return "Identifier:";
	}
}