package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

import es.upv.dsic.issi.dplfw.dfm.presentation.DfmEditor;

public class DfmPropertySheetPage extends TabbedPropertySheetPage {

	/**
	 * The DFM editor
	 */
	protected DfmEditor editor;
	
	/**
	 * Constructor for this property sheet page.
	 * 
	 * @param editor
	 *            the editor contributor of the property sheet page.
	 */
	public DfmPropertySheetPage(DfmEditor editor) {
		super(editor);
		this.editor = editor;
	}
	
	/**
	 * Get the EMF AdapterFactory for this editor.
	 * 
	 * @return the EMF AdapterFactory for this editor.
	 */
	public DfmEditor getEditor() {
		return editor;
	}

	/**
	 * Get the EMF AdapterFactory for this editor.
	 * 
	 * @return the EMF AdapterFactory for this editor.
	 */
	public AdapterFactory getAdapterFactory() {
		return editor.getAdapterFactory();
	}

}
