package es.upv.dsic.issi.dplfw.dfm.presentation.properties;


/**
 * An abstract implementation of a section for a field with a String property
 * value.
 * 
 * @author Anthony Hunter
 */
public abstract class AbstractStringPropertySection
	extends AbstractTextPropertySection {
	
	/**
	 * @see org.eclipse.ui.examples.views.properties.tabbed.hockeyleague.ui.properties.sections.AbstractTextPropertySection#isEqual(java.lang.String)
	 */
	protected boolean isEqual(String newText) {
		return getFeatureValueAsText().equals(newText);
	}
	
	/**
	 * @see org.eclipse.ui.examples.views.properties.tabbed.hockeyleague.ui.properties.sections.AbstractTextPropertySection#getFeatureValueAsText()
	 */
	protected String getFeatureValueAsText() {
		String string = (String)eObject.eGet(getFeature());
		if (string == null) {
			return "";//$NON-NLS-1$
		}
		return string;
	}
}