package es.upv.dsic.issi.dplfw.dfm.presentation.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfm.presentation.DfmEditor;

/**
 * An abstract implementation of a section with a radiobuttons selection
 * 
 * @author agomez
 */
public abstract class AbstractEnumPropertySection extends AbstractDfmPropertySection {

	List<Button> buttons = new ArrayList<Button>();

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.ITabbedPropertySection#createControls(org.eclipse.swt.widgets.Composite,
	 *      org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage)
	 */
	public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
		super.createControls(parent, tabbedPropertySheetPage);
		
		Composite composite = getWidgetFactory().createFlatFormComposite(parent);
		FormData data;

		EEnum eEnum = getEEnum();

		Composite radioComposite = getWidgetFactory().createFlatFormComposite(composite);
		data = new FormData();
		data.left = new FormAttachment(0, getStandardLabelWidth(composite, new String[] {getLabelText()}));
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(0, ITabbedPropertyConstants.VSPACE);
		radioComposite.setLayoutData(data);
		radioComposite.setLayout(new RowLayout(SWT.VERTICAL));
		
		for (EEnumLiteral literal: eEnum.getELiterals()) {
			Button button = getWidgetFactory().createButton(radioComposite, StringUtils.capitalize(literal.getName()), SWT.RADIO);
			button.setData(literal.getName());
			buttons.add(button);
			button.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					handleSelectionModified();
				}
			});
		}

		CLabel nameLabel = getWidgetFactory().createCLabel(composite, getLabelText());
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(radioComposite, -ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(radioComposite, 0, SWT.TOP);
		nameLabel.setLayoutData(data);

	}

	protected EEnum getEEnum() {
		EClassifier eClassifier = getFeature().getEType();
		return (EEnum) eClassifier;
	}

	/**
	 * Handle the selection modified event.
	 */
	protected void handleSelectionModified() {
		String newText = "";
		for (Button button : buttons) {
			if (button.getSelection()) {
				newText = (String) button.getData();
				break;
			}
		}
		boolean equals = isEqual(newText);
		if (!equals) {
			EditingDomain editingDomain = ((DfmEditor) getPart())
				.getEditingDomain();
			if (eObjectList.size() == 1) {
				/* apply the property change to single selected object */
				editingDomain.getCommandStack().execute(
					SetCommand.create(editingDomain, eObject, getFeature(),
							FeatureType.get(newText)));
			} else {
				CompoundCommand compoundCommand = new CompoundCommand();
				/* apply the property change to all selected elements */
				for (Iterator i = eObjectList.iterator(); i.hasNext();) {
					EObject nextObject = (EObject) i.next();
					compoundCommand.append(SetCommand.create(editingDomain,
						nextObject, getFeature(), 
						FeatureType.get(newText)));
				}
				editingDomain.getCommandStack().execute(compoundCommand);
			}
		}
	}

	/*
	 * @see org.eclipse.ui.views.properties.tabbed.view.ITabbedPropertySection#refresh()
	 */
	public void refresh() {
		for (Button button : buttons) {
			button.setSelection(isEqual((String) button.getData()));
		}
	}

	/**
	 * Determine if the provided string value is an equal representation of the
	 * current setting of the text property.
	 * 
	 * @param newText
	 *            the new string value.
	 * @return <code>true</code> if the new string value is equal to the
	 *         current property setting.
	 */
	protected boolean isEqual(String newText) {
		return getFeatureValueAsText().equals(newText);
	}

	/**
	 * Get the feature for the text field for the section.
	 * 
	 * @return the feature for the text.
	 */
	protected abstract EAttribute getFeature();


	/**
	 * Get the new value of the feature for the radiobuttons for the section.
	 * 
	 * @return the new value of the feature.
	 */
	protected String getFeatureValueAsText() {
		FeatureType type = (FeatureType)eObject.eGet(getFeature());
		if (type == null) {
			return "";//$NON-NLS-1$
		}
		return type.getName();
	}

	/**
	 * Get the label for the text field for the section.
	 * 
	 * @return the label for the text field.
	 */
	protected abstract String getLabelText();
}