package es.upv.dsic.issi.dplfw.dfm.presentation.actions;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.validation.marker.MarkerUtil;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.presentation.validation.ValidationDelegateClientSelector;

public class AnalyseModelAction extends ValidateAction {
	
	public AnalyseModelAction() {
		super();
		setText("&Analyse");
	}
	
	@Override
	public void run() {

		final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
		IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress() {
			public void run(final IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
 
				try {
 					BasicDiagnostic diagnostic = new BasicDiagnostic(MarkerUtil.VALIDATION_MARKER_TYPE,0,"Errors found!",null);

					// Default EMF checks
					diagnostic.add(validate(progressMonitor));
					
					// Configuration batch checks
					ValidationDelegateClientSelector.running = true;
					IBatchValidator validator = (IBatchValidator) ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
					validator.setIncludeLiveConstraints(true);
					validator.setReportSuccesses(true);
					IStatus status = validator.validate(selectedObjects);
					ValidationDelegateClientSelector.running = false;
					
					diagnostic.add(BasicDiagnostic.toDiagnostic(status));

					// Handle diagnostic
					final Diagnostic finalDiagnostic = diagnostic;
					shell.getDisplay().asyncExec(new Runnable() {
						public void run() {
							if (progressMonitor.isCanceled()) {
								handleDiagnostic(Diagnostic.CANCEL_INSTANCE);
							} else {
								handleDiagnostic(finalDiagnostic);
							}
						}
					});
				} finally {
					progressMonitor.done();
				}
			}
		};

		if (eclipseResourcesUtil != null) {
			runnableWithProgress = eclipseResourcesUtil.getWorkspaceModifyOperation(runnableWithProgress);
		}

		try {
			// This runs the operation, and shows progress.
			// (It appears to be a bad thing to fork this onto another thread.)
			//
			new ProgressMonitorDialog(shell).run(true, true, runnableWithProgress);
		} catch (Exception exception) {
			EMFEditUIPlugin.INSTANCE.log(exception);
		}
	}


	@Override
	protected void handleDiagnostic(Diagnostic diagnostic) {
		int severity = diagnostic.getSeverity();
		String title = null;
		String message = null;

		if (severity == Diagnostic.ERROR || severity == Diagnostic.WARNING) {
			title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title");
			message = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message");
		} else {
			title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationResults_title");
			message = EMFEditUIPlugin.INSTANCE.getString(
					severity == Diagnostic.OK ? "_UI_ValidationOK_message" : "_UI_ValidationResults_message");
		}

		if (diagnostic.getSeverity() == Diagnostic.OK) {
			MessageDialog.openInformation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, message);
		} else {
			DiagnosticDialog.open(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, message, diagnostic);
		}
		
	    Resource resource = eclipseResourcesUtil != null ? domain.getResourceSet().getResources().get(0) : null;
		
	    if (resource != null) {
			eclipseResourcesUtil.deleteMarkers(resource);
			for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
				if (childDiagnostic.getSource().equals("org.eclipse.emf.ecore")) {
					for (Diagnostic childChildDiagnostic : childDiagnostic.getChildren()) {
						eclipseResourcesUtil.createMarkers(resource, childChildDiagnostic);
					}
				}
			}
		}
	}
	

	@Override
	public boolean updateSelection(IStructuredSelection selection) {
		super.updateSelection(selection);
		if (selectedObjects != null && !selectedObjects.isEmpty()) {
			return (selectedObjects.get(0) instanceof DocumentFeatureModel);
		}
		return false;
	}

}