/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfm.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

import es.upv.dsic.issi.dplfw.dfm.DfmFactory;
import es.upv.dsic.issi.dplfw.dfm.DfmPackage;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.ExcludesFeature;
import es.upv.dsic.issi.dplfw.dfm.RequiresFeature;

/**
 * This is the item provider adapter for a {@link es.upv.dsic.issi.dplfw.dfm.DocumentFeature} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DocumentFeatureItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider, IStructuredItemContentProvider, ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DocumentFeatureItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addVisibleNamePropertyDescriptor(object);
			addIdNamePropertyDescriptor(object);
			addTypePropertyDescriptor(object);
			addDocumentContextPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Id Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addIdNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_DocumentFeature_idName_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_DocumentFeature_idName_feature", "_UI_DocumentFeature_type"),
				 DfmPackage.Literals.DOCUMENT_FEATURE__ID_NAME,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Type feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addTypePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_DocumentFeature_type_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_DocumentFeature_type_feature", "_UI_DocumentFeature_type"),
				 DfmPackage.Literals.DOCUMENT_FEATURE__TYPE,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Document Context feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDocumentContextPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_DocumentFeature_documentContext_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_DocumentFeature_documentContext_feature", "_UI_DocumentFeature_type"),
				 DfmPackage.Literals.DOCUMENT_FEATURE__DOCUMENT_CONTEXT,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Visible Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addVisibleNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_DocumentFeature_visibleName_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_DocumentFeature_visibleName_feature", "_UI_DocumentFeature_type"),
				 DfmPackage.Literals.DOCUMENT_FEATURE__VISIBLE_NAME,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(DfmPackage.Literals.DOCUMENT_FEATURE__REQUIRES);
			childrenFeatures.add(DfmPackage.Literals.DOCUMENT_FEATURE__EXCLUDES);
			childrenFeatures.add(DfmPackage.Literals.DOCUMENT_FEATURE__ANNOTATIONS);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean shouldComposeCreationImage() {
		return true;
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	@Override
	public String getText(Object object) {
		DocumentFeature df = (DocumentFeature)object;
		String label = String.format("%s (id:%s)",
				df.getVisibleName(),
				df.getIdName());
		return df.getVisibleName() == null || df.getVisibleName().length() == 0 ?
			getString("_UI_DocumentFeature_type_short") :
			getString("_UI_DocumentFeature_type_short") + ": " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(DocumentFeature.class)) {
			case DfmPackage.DOCUMENT_FEATURE__ID_NAME:
				for (RequiresFeature requires : ((DocumentFeature)notification.getNotifier()).getIsRequiredBy()) {
					fireNotifyChanged(new ViewerNotification(notification, requires, false, true));
				}
				for (ExcludesFeature excludes : ((DocumentFeature)notification.getNotifier()).getIsExcludedBy()) {
					fireNotifyChanged(new ViewerNotification(notification, excludes, false, true));
				}
			case DfmPackage.DOCUMENT_FEATURE__TYPE:
			case DfmPackage.DOCUMENT_FEATURE__VISIBLE_NAME:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case DfmPackage.DOCUMENT_FEATURE__REQUIRES:
			case DfmPackage.DOCUMENT_FEATURE__ANNOTATIONS:
			case DfmPackage.DOCUMENT_FEATURE__EXCLUDES:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(DfmPackage.Literals.DOCUMENT_FEATURE__REQUIRES,
				 DfmFactory.eINSTANCE.createRequiresFeature()));

		newChildDescriptors.add
			(createChildParameter
				(DfmPackage.Literals.DOCUMENT_FEATURE__EXCLUDES,
				 DfmFactory.eINSTANCE.createExcludesFeature()));

		newChildDescriptors.add
			(createChildParameter
				(DfmPackage.Literals.DOCUMENT_FEATURE__ANNOTATIONS,
				 DfmFactory.eINSTANCE.createAnnotation()));
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return DfmEditPlugin.INSTANCE;
	}

	protected Object getTypeImage(Object object) {
		DocumentFeature documentFeature = (DocumentFeature) object;
		switch (documentFeature.getType()) {
			case OPTIONAL:
				return getResourceLocator().getImage("full/obj16/Optional");
			case MANDATORY:
				return getResourceLocator().getImage("full/obj16/Mandatory");
			case OR:
				return getResourceLocator().getImage("full/obj16/Or");
			case ALTERNATIVE:
				return getResourceLocator().getImage("full/obj16/Alternative");
			default:
				return null;
		}
	}
	
}
